/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class FertilizedSoilBlock
extends Block {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)3);

    public FertilizedSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(3)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)SIZE)) {
            case 0 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
            case 1 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
            case 2 -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == ObjectRegistry.PITCHFORK.get()) {
            int newSize = (Integer)state.m_61143_((Property)SIZE) - 1;
            if (newSize < 0) {
                level.m_7471_(pos, false);
                this.spawnBreakParticles(level, pos, state);
                level.m_5594_(null, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(newSize)), 3);
                this.applyBoneMealEffect(level, pos);
                this.spawnBreakParticles(level, pos, state);
                level.m_5594_(null, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_41720_() instanceof HoeItem) {
            int currentSize = (Integer)state.m_61143_((Property)SIZE);
            if (currentSize == 3) {
                level.m_7731_(pos, ((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get()).m_49966_(), 3);
                if (!player.m_7500_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                level.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private void spawnBreakParticles(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.2);
        }
    }

    private void applyBoneMealEffect(Level level, BlockPos centerPos) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos.m_121990_((BlockPos)centerPos.m_7918_(-5, -1, -5), (BlockPos)centerPos.m_7918_(5, 1, 5)).forEach(pos -> {
                BonemealableBlock bonemealableBlock;
                BlockState blockState;
                Block block;
                if (serverLevel.f_46441_.m_188503_(100) < 20 && (block = (blockState = serverLevel.m_8055_(pos)).m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, pos, blockState, false)) {
                    bonemealableBlock.m_214148_(serverLevel, serverLevel.f_46441_, pos, blockState);
                }
            });
        }
    }
}

