/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.util;

import com.berksire.furniture.client.entity.ChairEntity;
import com.berksire.furniture.registry.EntityTypeRegistry;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FurnitureUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>> CHAIRS = new HashMap<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>>();
    public static final EnumProperty<LineConnectingType> LINE_CONNECTING_TYPE = EnumProperty.m_61587_((String)"type", LineConnectingType.class);

    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = FurnitureUtil.registerWithoutItem(registerB, registrarB, name, block);
        FurnitureUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static InteractionResult onUse(Level world, Player player, InteractionHand hand, BlockHitResult hit, double extraHeight) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (FurnitureUtil.isPlayerSitting(player)) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hit.m_82425_();
        if (!FurnitureUtil.isOccupied(world, hitPos) && player.m_21120_(hand).m_41619_()) {
            ChairEntity chair = (ChairEntity)((EntityType)EntityTypeRegistry.CHAIR.get()).m_20615_(world);
            assert (chair != null);
            chair.m_7678_((double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.25 + extraHeight, (double)hitPos.m_123343_() + 0.5, 0.0f, 0.0f);
            if (FurnitureUtil.addChairEntity(world, hitPos, chair, player.m_20183_())) {
                world.m_7967_((Entity)chair);
                player.m_20329_((Entity)chair);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void onStateReplaced(Level world, BlockPos pos) {
        ChairEntity entity;
        if (!world.f_46443_ && (entity = FurnitureUtil.getChairEntity(world, pos)) != null) {
            FurnitureUtil.removeChairEntity(world, pos);
            entity.m_20153_();
        }
    }

    public static boolean addChairEntity(Level world, BlockPos blockPos, ChairEntity entity, BlockPos playerPos) {
        if (!world.f_46443_) {
            ResourceLocation id = FurnitureUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.m_5776_() && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, ChairEntity chairEntity) {
        ResourceLocation id;
        if (!player.m_9236_().m_5776_() && CHAIRS.containsKey(id = FurnitureUtil.getDimensionTypeId(player.m_9236_()))) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (BlockPos)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = FurnitureUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.m_220362_().m_135782_();
    }

    public static enum LineConnectingType implements StringRepresentable
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }

    public static enum SmokeType implements StringRepresentable
    {
        HEAVY_SMOKE("heavy_smoke"),
        SMOKE("smoke"),
        NO_SMOKE("no_smoke");

        private final String name;

        private SmokeType(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public SmokeType getNext() {
            return switch (this) {
                case HEAVY_SMOKE -> SMOKE;
                case SMOKE -> NO_SMOKE;
                default -> HEAVY_SMOKE;
            };
        }

        public String getTranslationKey() {
            return "tooltip.furniture.smoke_type." + this.name;
        }
    }

    public static enum VerticalConnectingType implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        NONE("none");

        private final String name;
        public static final EnumProperty<VerticalConnectingType> VERTICAL_CONNECTING_TYPE;

        private VerticalConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            VERTICAL_CONNECTING_TYPE = EnumProperty.m_61587_((String)"type", VerticalConnectingType.class);
        }
    }
}

