/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.entity;

import com.berksire.furniture.registry.ObjectRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PellsEntity
extends Mob {
    private static final EntityDataAccessor<Float> LAST_DAMAGE = SynchedEntityData.m_135353_(PellsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart;
    private static final EntityDataAccessor<Boolean> IS_CRIT = SynchedEntityData.m_135353_(PellsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float lastDamageOffset = 0.0f;
    public float lastDamageOffsetPrev = 0.0f;

    public PellsEntity(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(0.0f);
    }

    @NotNull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_CRIT, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5830_()) {
            this.m_19998_((ItemLike)ObjectRegistry.PELLS.get());
            this.m_146870_();
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        Level level = pPlayer.m_9236_();
        if (pPlayer.m_6144_()) {
            if (!level.m_5776_()) {
                if (!pPlayer.m_7500_()) {
                    level.m_7967_((Entity)new ItemEntity(level, this.m_20185_(), this.m_20186_() + 0.7, this.m_20189_(), ((Item)ObjectRegistry.PELLS.get()).m_7968_()));
                }
                this.m_6089_();
            } else {
                for (int i = 0; i < 14; ++i) {
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50335_.m_49966_()), this.m_20185_(), this.m_20186_() + 0.7, this.m_20189_(), 0.0, 0.02, 0.0);
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50745_.m_49966_()), this.m_20185_(), this.m_20186_() + 0.7, this.m_20189_(), 0.0, 0.02, 0.0);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6074_() {
        this.m_6475_(this.m_9236_().m_269111_().m_287172_(), Float.MAX_VALUE);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == this.m_269291_().m_269341_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_6074_();
            return false;
        }
        BlockState state = Blocks.f_50335_.m_49966_();
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_(), this.m_20186_() + 0.7, this.m_20189_(), 0.0, 0.02, 0.0);
        }
        this.f_19804_.m_135381_(LAST_DAMAGE, (Object)Float.valueOf(0.0f));
        if (this.f_20916_ == 0) {
            this.f_19804_.m_135381_(LAST_DAMAGE, (Object)Float.valueOf(amount));
            boolean isCrit = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_36403_(0.5f) > 0.9f && source.m_269533_(DamageTypeTags.f_268630_);
            this.f_19804_.m_135381_(IS_CRIT, (Object)isCrit);
        }
        this.m_5834_();
        this.m_9236_().m_269196_((Entity)this, source);
        return true;
    }

    public float getLastDamage() {
        return ((Float)this.f_19804_.m_135370_(LAST_DAMAGE)).floatValue();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(@NotNull Entity pEntity) {
    }

    public boolean m_6573_(@NotNull Player pPlayer) {
        return false;
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_142065_() {
        return false;
    }

    protected float m_5632_(float pYRot, float pAnimStep) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_7313_(@NotNull Entity pEntity) {
        return pEntity instanceof Player && !this.m_9236_().m_7966_((Player)pEntity, this.m_20183_());
    }

    @NotNull
    public Vec3 m_7371_(float pPartialTicks) {
        return super.m_7371_(pPartialTicks);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }
}

