/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StreetLanternWallBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty BULBS = IntegerProperty.m_61631_((String)"bulbs", (int)0, (int)1);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final Map<Direction, VoxelShape> SHAPE_SINGLE = StreetLanternWallBlock.createDirectionalShapes(StreetLanternWallBlock::makeSingleShape);
    public static final Map<Direction, VoxelShape> SHAPE_DOUBLE = StreetLanternWallBlock.createDirectionalShapes(StreetLanternWallBlock::makeDoubleShape);

    public StreetLanternWallBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BULBS, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, BULBS, LIT});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        if ((Integer)state.m_61143_((Property)BULBS) == 0) {
            return SHAPE_SINGLE.get(direction);
        }
        return SHAPE_DOUBLE.get(direction);
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.5625, (double)0.4375, (double)0.6875, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.5, (double)0.5, (double)0.625, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.1875, (double)0.875, (double)0.625, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.25, (double)0.625, (double)0.5625, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeDoubleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.5, (double)0.3125, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5625, (double)0.4375, (double)0.375, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.5, (double)0.5, (double)0.9375, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.5625, (double)0.4375, (double)1.0, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.875, (double)0.625, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.2569320439671243, (double)0.3125, (double)0.59375, (double)0.7569320439671243, (double)0.5625, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static Map<Direction, VoxelShape> createDirectionalShapes(Supplier<VoxelShape> shapeSupplier) {
        return (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, (VoxelShape)shapeSupplier.get()));
            }
        });
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState newState;
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61124_((Property)BULBS, (Comparable)Integer.valueOf(Math.min(1, (Integer)blockState.m_61143_((Property)BULBS) + 1)));
        }
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        Direction direction = context.m_43719_();
        if (direction == Direction.DOWN || direction == Direction.UP) {
            direction = context.m_8125_().m_122424_();
        }
        if (this.m_7898_(newState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction), (LevelReader)context.m_43725_(), context.m_8083_())) {
            return (BlockState)newState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)BULBS) < 1 || super.m_6864_(state, useContext);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }
}

