/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import trofers.trophy.TrophyManager;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;
import trofers.util.JsonHelper;

public record Trophy(ResourceLocation id, Optional<Component> name, List<Component> tooltip, DisplayInfo display, Animation animation, ItemStack item, Optional<EntityInfo> entity, ColorInfo colors, EffectInfo effects, boolean isHidden) {
    @Nullable
    public static Trophy getTrophy(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
        if (!blockEntityTag.m_128425_("Trophy", 8)) {
            return null;
        }
        try {
            return TrophyManager.get(new ResourceLocation(blockEntityTag.m_128461_("Trophy")));
        }
        catch (ResourceLocationException resourceLocationException) {
            return null;
        }
    }

    public ItemStack createItem(ItemLike trophyBase) {
        return Trophy.createItem(trophyBase, this.id());
    }

    public static ItemStack createItem(ItemLike trophyBase, ResourceLocation id) {
        ItemStack stack = new ItemStack(trophyBase);
        stack.m_41698_("BlockEntityTag").m_128359_("Trophy", id.toString());
        return stack;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeBoolean(this.name.isPresent());
        this.name.ifPresent(arg_0 -> ((FriendlyByteBuf)buffer).m_130083_(arg_0));
        this.display.toNetwork(buffer);
        this.animation.toNetwork(buffer);
        buffer.m_130055_(this.item);
        buffer.writeBoolean(this.entity.isPresent());
        this.entity.ifPresent(entityInfo -> entityInfo.toNetwork(buffer));
        this.colors.toNetwork(buffer);
        this.effects.toNetwork(buffer);
        for (Component line : this.tooltip) {
            buffer.writeBoolean(true);
            buffer.m_130083_(line);
        }
        buffer.writeBoolean(false);
        buffer.writeBoolean(this.isHidden);
    }

    public static Trophy fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Component name = null;
        if (buffer.readBoolean()) {
            name = buffer.m_130238_();
        }
        DisplayInfo display = DisplayInfo.fromNetwork(buffer);
        Animation animation = Animation.fromNetwork(buffer);
        ItemStack item = buffer.m_130267_();
        EntityInfo entity = null;
        if (buffer.readBoolean()) {
            entity = EntityInfo.fromNetwork(buffer);
        }
        ColorInfo colors = ColorInfo.fromNetwork(buffer);
        EffectInfo effects = EffectInfo.fromNetwork(buffer);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        while (buffer.readBoolean()) {
            tooltip.add(buffer.m_130238_());
        }
        boolean isHidden = buffer.readBoolean();
        return new Trophy(id, Optional.ofNullable(name), tooltip, display, animation, item, Optional.ofNullable(entity), colors, effects, isHidden);
    }

    public static Trophy fromJson(JsonElement element, ResourceLocation id) {
        JsonObject object = GsonHelper.m_13918_((JsonElement)element, (String)"trophy");
        EntityInfo entity = null;
        if (object.has("entity")) {
            entity = EntityInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"entity"));
        }
        ItemStack item = ItemStack.f_41583_;
        if (object.has("item")) {
            item = JsonHelper.deserializeItem(object, "item");
        }
        Animation animation = Animation.STATIC;
        if (object.has("animation")) {
            animation = Animation.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"animation"));
        }
        DisplayInfo display = DisplayInfo.NONE;
        if (object.has("display")) {
            display = DisplayInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"display"));
        }
        ColorInfo colors = ColorInfo.NONE;
        if (object.has("colors")) {
            colors = ColorInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"colors"));
        }
        MutableComponent name = null;
        if (object.has("name")) {
            name = Component.Serializer.m_130691_((JsonElement)object.get("name"));
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (object.has("tooltip")) {
            JsonElement tooltipElement = object.get("tooltip");
            if (!tooltipElement.isJsonArray()) {
                tooltip.add((Component)Component.Serializer.m_130691_((JsonElement)tooltipElement));
            } else {
                JsonArray lines = GsonHelper.m_13933_((JsonObject)object, (String)"tooltip");
                for (JsonElement line : lines) {
                    tooltip.add((Component)Component.Serializer.m_130691_((JsonElement)line));
                }
            }
        }
        EffectInfo effects = EffectInfo.NONE;
        if (object.has("effects")) {
            effects = EffectInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"effects"));
        }
        boolean isHidden = false;
        if (object.has("isHidden")) {
            isHidden = GsonHelper.m_13912_((JsonObject)object, (String)"isHidden");
        }
        return new Trophy(id, Optional.ofNullable(name), tooltip, display, animation, item, Optional.ofNullable(entity), colors, effects, isHidden);
    }
}

