/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.croptania.blocks;

import io.github.chakyl.croptania.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class CropnoliaBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 3;
    private static final int MAX_MANA = CropnoliaBlockEntity.manaForAge(10) * 3 * 3;
    public static final int MANA_BASE = 10;
    public static final int MANA_BASE_GOG = 2;

    public CropnoliaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CROPNOLIA.get(), pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 100 == 0) {
            BlockPos flowerPos = this.m_58899_();
            boolean foundCrop = false;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)flowerPos.m_7918_(-3, 0, -3), (BlockPos)flowerPos.m_7918_(3, 1, 3))) {
                CropBlock cropBlock;
                BlockState crop = this.f_58857_.m_8055_(blockpos);
                Block block = crop.m_60734_();
                if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_52307_(crop)) continue;
                foundCrop = true;
                int age = cropBlock.m_7419_();
                this.addMana(CropnoliaBlockEntity.manaForAge(age));
                this.f_58857_.m_7731_(blockpos, cropBlock.m_52289_(0), 2);
                for (int i = 0; i < 20; ++i) {
                    Vec3 offset = crop.m_60824_((BlockGetter)this.f_58857_, blockpos);
                    double x = (double)blockpos.m_123341_() + offset.f_82479_;
                    double y = (double)blockpos.m_123342_() + offset.f_82480_;
                    double z = (double)blockpos.m_123343_() + offset.f_82481_;
                    SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.m_188501_(), (float)0.0f, (float)170.0f, (float)0.0f, (int)5);
                    this.f_58857_.m_7106_((ParticleOptions)data, x + (double)Mth.m_216283_((RandomSource)this.f_58857_.f_46441_, (float)0.0f, (float)0.9f), y + (double)Mth.m_216283_((RandomSource)this.f_58857_.f_46441_, (float)0.2f, (float)0.4f), z + (double)Mth.m_216283_((RandomSource)this.f_58857_.f_46441_, (float)0.0f, (float)0.9f), 0.0, 0.0, 0.0);
                }
            }
            if (foundCrop) {
                this.f_58857_.m_5594_(null, flowerPos, BotaniaSounds.terraBlade, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.sync();
        }
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)3);
    }

    private static int manaForAge(int age) {
        return (XplatAbstractions.INSTANCE.gogLoaded() ? 2 : 10) * (int)Math.pow(2.0, age);
    }

    public int getMaxMana() {
        return MAX_MANA;
    }

    public int getColor() {
        return 16368171;
    }
}

