/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon.color;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class HuePickerAddon
extends BasicScreenAddon {
    private final Consumer<Float> consumer;
    private float hue;

    protected HuePickerAddon(int posX, int posY, float hue, Consumer<Float> consumer) {
        super(posX, posY);
        this.consumer = consumer;
        this.hue = hue;
    }

    @Override
    public int getXSize() {
        return 146;
    }

    @Override
    public int getYSize() {
        return 8;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.drawColorBar(guiGraphics, this.getPosX() + guiX, this.getPosY() + guiY, this.getXSize(), this.getYSize());
        AssetUtil.drawAsset(guiGraphics, screen, provider.getAsset(AssetTypes.HUE_PICKER), guiX + (int)((float)this.getPosX() + this.hue * (float)this.getXSize()) - 3, guiY + this.getPosY() - 3);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    private void drawColorBar(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            guiGraphics.m_280509_(x + i, y, x + i + 1, y + height, Color.getHSBColor((float)i / (float)width, 1.0f, 1.0f).getRGB());
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.hue = (float)((mouseX - (double)this.getPosX()) / (double)this.getXSize());
        this.consumer.accept(Float.valueOf(this.hue));
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.hue = ((float)mouseX - (float)this.getPosX()) / (float)this.getXSize();
        this.consumer.accept(Float.valueOf(this.hue));
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void setHue(float hue) {
        this.hue = hue;
    }
}

