/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BasicTileBlock<T extends BasicTile<T>>
extends BasicBlock
implements EntityBlock {
    private final Class<T> tileClass;

    public BasicTileBlock(String name, BlockBehaviour.Properties properties, Class<T> tileClass) {
        super(name, properties);
        this.tileClass = tileClass;
        NBTManager.getInstance().scanTileClassForAnnotations(tileClass);
    }

    public abstract BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory();

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        this.getTile((BlockGetter)worldIn, pos).ifPresent(tile -> tile.onNeighborChanged(blockIn, fromPos));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return this.getTile((BlockGetter)worldIn, pos).map(tile -> tile.onActivated(player, hand, ray.m_82434_(), ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_)).orElseGet(() -> super.m_6227_(state, worldIn, pos, player, hand, ray));
    }

    public Optional<T> getTile(BlockGetter access, BlockPos pos) {
        return TileUtil.getTileEntity(access, pos, this.tileClass);
    }

    public Class<T> getTileClass() {
        return this.tileClass;
    }

    @Nullable
    public <R extends BlockEntity> BlockEntityTicker<R> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<R> p_153214_) {
        return (level, pos, state, blockEntity) -> {
            if (blockEntity instanceof ITickableBlockEntity) {
                if (level.m_5776_()) {
                    ((ITickableBlockEntity)blockEntity).clientTick(level, pos, state, blockEntity);
                } else {
                    ((ITickableBlockEntity)blockEntity).serverTick(level, pos, state, blockEntity);
                }
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel p_153210_, T p_153211_) {
        return super.m_214009_(p_153210_, p_153211_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return this.getTileEntityFactory().m_155267_(p_153215_, p_153216_);
    }
}

