/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.mehvahdjukaar.jeed.common.EffectWindowEntry;
import net.mehvahdjukaar.jeed.plugin.rei.REIPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;

public class EffectInfoDisplay
extends EffectWindowEntry
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<List<EntryStack<?>>> slots;
    private final List<EntryIngredient> outputEntries;

    protected EffectInfoDisplay(MobEffectInstance effectInstance, Component description) {
        super(effectInstance, List.of(description));
        List<ItemStack> providers = EffectInfoDisplay.computeItemProviders(effectInstance.m_19544_());
        List<Ingredient> ingredientsList = EffectInfoDisplay.groupIngredients(providers);
        ArrayList<EntryIngredient> allInputs = new ArrayList<EntryIngredient>(ingredientsList.stream().map(EntryIngredients::ofIngredient).toList());
        this.outputEntries = List.of(EntryIngredient.of((EntryStack)EntryStack.of(REIPlugin.EFFECT_ENTRY_TYPE, (Object)effectInstance).normalize()));
        allInputs.addAll(this.outputEntries);
        allInputs.addAll(EffectInfoDisplay.computeEffectProviders(this.effect.m_19544_()).stream().map(e -> EntryStack.of(REIPlugin.EFFECT_ENTRY_TYPE, (Object)new MobEffectInstance(e)).normalize()).map(EntryIngredient::of).toList());
        allInputs.addAll(EffectInfoDisplay.computeFluidProvides(this.effect.m_19544_()).stream().map(f -> EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)FluidStack.create((Fluid)f, (long)1000L)).normalize()).map(EntryIngredient::of).toList());
        this.inputEntries = allInputs.stream().toList();
        this.slots = EffectInfoDisplay.divideIntoSlots(providers, EntryIngredients::ofItemStacks);
    }

    public List<List<EntryStack<?>>> getSlots() {
        return this.slots;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.EFFECTS_INFO_CATEGORY;
    }

    public static EffectInfoDisplay create(MobEffect effect) {
        Component text = EffectInfoDisplay.getDescription(effect);
        return new EffectInfoDisplay(new MobEffectInstance(effect), text);
    }
}

