/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.IPlugin;
import net.mehvahdjukaar.jeed.forge.JeedImpl;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;

public class Jeed {
    public static final String MOD_ID = "jeed";
    public static final Logger LOGGER = LogManager.getLogger((String)"Jeed");
    public static IPlugin PLUGIN;
    public static boolean EMI;
    public static final TagKey<MobEffect> HIDDEN;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getHiddenEffects() {
        return JeedImpl.getHiddenEffects();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<?> getEffectProviderSerializer() {
        return JeedImpl.getEffectProviderSerializer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeType<EffectProviderRecipe> getEffectProviderType() {
        return JeedImpl.getEffectProviderType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<?> getPotionProviderSerializer() {
        return JeedImpl.getPotionProviderSerializer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeType<PotionProviderRecipe> getPotionProviderType() {
        return JeedImpl.getPotionProviderType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasIngredientList() {
        return JeedImpl.hasIngredientList();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasEffectBox() {
        return JeedImpl.hasEffectBox();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasEffectColor() {
        return JeedImpl.hasEffectColor();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean rendersSlots() {
        return JeedImpl.rendersSlots();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean suppressVanillaTooltips() {
        return JeedImpl.suppressVanillaTooltips();
    }

    public static <T> boolean isTagged(T entry, Registry<T> registry, TagKey<T> tag) {
        return registry.m_203300_(registry.m_7447_(entry)).map(h -> h.m_203656_(tag)).orElse(false);
    }

    public static List<MobEffect> getEffectList() {
        return BuiltInRegistries.f_256974_.m_123024_().filter(e -> !Jeed.isTagged(e, BuiltInRegistries.f_256974_, HIDDEN) && !Jeed.getHiddenEffects().contains(BuiltInRegistries.f_256974_.m_7981_(e).toString())).sorted((a, b) -> Constants.ID_COMPARATOR.compare(BuiltInRegistries.f_256974_.m_7981_(a), BuiltInRegistries.f_256974_.m_7981_(b))).toList();
    }

    static {
        EMI = false;
        HIDDEN = TagKey.m_203882_((ResourceKey)Registries.f_256929_, (ResourceLocation)Jeed.res("hidden"));
    }
}

