/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.TemporalPouchItem;
import ky.someone.mods.gag.misc.Pigment;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GAGCommands {
    public static final SimpleCommandExceptionType INVALID_COLOR = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Invalid rgb!"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gag").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"pigment_jar").then(Commands.m_82129_((String)"rgb", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> {
            String clrString = StringArgumentType.getString((CommandContext)ctx, (String)"rgb");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            try {
                int color = Integer.parseInt(clrString, 16);
                ItemStack stack = Pigment.ofRgb(color, amount).asJar();
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
                if (player.m_36356_(stack)) {
                    player.f_36096_.m_38946_();
                } else {
                    ItemEntity asEntity = player.m_36176_(stack, false);
                    if (asEntity != null) {
                        asEntity.m_32061_();
                        asEntity.m_266426_(player.m_20148_());
                    }
                }
                return 1;
            }
            catch (NumberFormatException e) {
                throw INVALID_COLOR.create();
            }
        }))))).then(Commands.m_82127_((String)"give_time").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            int time = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ticks");
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!(stack.m_41720_() instanceof TemporalPouchItem)) continue;
                int storedGrains = TemporalPouchItem.getStoredGrains(stack);
                int newTime = Math.min(storedGrains + time, (Integer)GAGConfig.SandsOfTime.POUCH_CAPACITY.get());
                TemporalPouchItem.setStoredGrains(stack, newTime);
                player.f_36095_.m_38946_();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.gag.give_time.success", (Object[])new Object[]{time, player.m_5446_()}), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.gag.give_time.no_pouch", (Object[])new Object[]{player.m_5446_()}));
            return 0;
        })))));
    }
}

