/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.station.StationBlock;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class GlobalStation
extends SingleBlockEntityEdgePoint {
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;
    public Map<BlockPos, GlobalPackagePort> connectedPorts = new HashMap<BlockPos, GlobalPackagePort>();

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        BlockState state = blockEntity.m_58900_();
        this.assembling = state != null && state.m_61138_((Property)StationBlock.ASSEMBLING) && (Boolean)state.m_61143_((Property)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.name = nbt.m_128461_("Name");
        this.assembling = nbt.m_128471_("Assembling");
        this.nearestTrain = new WeakReference<Object>(null);
        this.connectedPorts.clear();
        ListTag portList = nbt.m_128437_("Ports", 10);
        NBTHelper.iterateCompoundList((ListTag)portList, c -> {
            GlobalPackagePort port = new GlobalPackagePort();
            port.address = c.m_128461_("Address");
            port.offlineBuffer.deserializeNBT(c.m_128469_("OfflineBuffer"));
            port.primed = c.m_128471_("Primed");
            this.connectedPorts.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos")), port);
        });
    }

    @Override
    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.m_130277_();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.m_130135_();
        }
    }

    @Override
    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.m_128359_("Name", this.name);
        nbt.m_128379_("Assembling", this.assembling);
        nbt.m_128365_("Ports", (Tag)NBTHelper.writeCompoundList(this.connectedPorts.entrySet(), e -> {
            CompoundTag c = new CompoundTag();
            c.m_128359_("Address", ((GlobalPackagePort)e.getValue()).address);
            c.m_128365_("OfflineBuffer", (Tag)((GlobalPackagePort)e.getValue()).offlineBuffer.serializeNBT());
            c.m_128379_("Primed", ((GlobalPackagePort)e.getValue()).primed);
            c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)e.getKey())));
            return c;
        }));
    }

    @Override
    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.m_130070_(this.name);
        buffer.writeBoolean(this.assembling);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.m_130064_(this.blockEntityPos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }

    public void runMailTransfer() {
        Train train = this.getPresentTrain();
        if (train == null || this.connectedPorts.isEmpty()) {
            return;
        }
        ServerLevel level = null;
        for (Carriage carriage : train.carriages) {
            ItemStack result;
            CombinedInvWrapper carriageInventory;
            Level level2;
            CarriageContraptionEntity entity;
            if (level == null && (entity = carriage.anyAvailableEntity()) != null && (level2 = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level2;
                level = sl.m_7654_().m_129880_(this.getBlockEntityDimension());
            }
            if ((carriageInventory = carriage.storage.getAllItems()) == null) continue;
            for (Map.Entry entry : this.connectedPorts.entrySet()) {
                BlockEntity blockEntity;
                GlobalPackagePort port = (GlobalPackagePort)entry.getValue();
                BlockPos pos = (BlockPos)entry.getKey();
                PostboxBlockEntity box = null;
                Object postboxInventory = port.offlineBuffer;
                if (level != null && level.m_46749_(pos) && (blockEntity = level.m_7702_(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)blockEntity;
                    postboxInventory = ppbe.inventory;
                    box = ppbe;
                }
                for (int slot = 0; slot < postboxInventory.getSlots(); ++slot) {
                    ItemStack stack = postboxInventory.getStackInSlot(slot);
                    if (!PackageItem.isPackage(stack) || PackageItem.matchAddress(stack, port.address) || !(result = ItemHandlerHelper.insertItemStacked((IItemHandler)carriageInventory, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
                    postboxInventory.setStackInSlot(slot, ItemStack.f_41583_);
                    Create.RAILWAYS.markTracksDirty();
                    if (box == null) continue;
                    box.spawnParticles();
                }
            }
            block3: for (int slot = 0; slot < carriageInventory.getSlots(); ++slot) {
                ItemStack itemStack = carriageInventory.getStackInSlot(slot);
                if (!PackageItem.isPackage(itemStack)) continue;
                for (Map.Entry<BlockPos, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                    BlockEntity blockEntity;
                    GlobalPackagePort port = entry.getValue();
                    BlockPos pos = entry.getKey();
                    PostboxBlockEntity box = null;
                    if (!PackageItem.matchAddress(itemStack, port.address)) continue;
                    Object postboxInventory = port.offlineBuffer;
                    if (level != null && level.m_46749_(pos) && (blockEntity = level.m_7702_(pos)) instanceof PostboxBlockEntity) {
                        PostboxBlockEntity ppbe = (PostboxBlockEntity)blockEntity;
                        postboxInventory = ppbe.inventory;
                        box = ppbe;
                    }
                    if (!(result = ItemHandlerHelper.insertItemStacked((IItemHandler)postboxInventory, (ItemStack)itemStack, (boolean)false)).m_41619_()) continue;
                    Create.RAILWAYS.markTracksDirty();
                    carriageInventory.setStackInSlot(slot, ItemStack.f_41583_);
                    if (box == null) continue block3;
                    box.spawnParticles();
                    continue block3;
                }
            }
        }
    }

    public static class GlobalPackagePort {
        public String address = "";
        public ItemStackHandler offlineBuffer = new ItemStackHandler(18);
        public boolean primed = false;
    }
}

