/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScorpionBabyEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final int baseAttackDuration = 10;
    private final int baseAttackActionPoint = 5;
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");

    public ScorpionBabyEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(4, (Goal)new BaseMeleeAttackGoal(this, 10, 5, 5, 1.0, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.0 + (double)entity.m_20205_();
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_(SoundEvents.f_12419_, 1.0f, 1.0f);
                return super.executeAttack(target);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6, 10));
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(@NotNull Pose p_21131_, @NotNull EntityDimensions p_21132_) {
        return 0.1f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_12421_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12422_, 1.0f, 1.0f);
    }
}

