/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.config;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarycreatures.LegendaryCreatures;

public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void register() {
        try {
            Files.createDirectory(LegendaryCreatures.modConfigPath, new FileAttribute[0]);
            Files.createDirectory(LegendaryCreatures.modConfigJson, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LegendaryCreatures.LOGGER.error("Failed to create Legendary Creatures config directories");
            e.printStackTrace();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, "legendarycreatures/legendarycreatures-common.toml");
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue desertMojoBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue desertMojoKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue forestMojoBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue forestMojoKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue houndBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue houndKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue scarecrowBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue scarecrowKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue scorpionBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue scorpionKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue scorpionBabyBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue scorpionBabyKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue wispBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue wispKillingEntitySpawn;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> wispPurseXpReward;
        public final ForgeConfigSpec.BooleanValue netherWispBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue netherWispKillingEntitySpawn;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> netherWispPurseXpReward;
        public final ForgeConfigSpec.BooleanValue enderWispBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue enderWispKillingEntitySpawn;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> enderWispPurseXpReward;
        public final ForgeConfigSpec.BooleanValue corpseEaterBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue corpseEaterKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue peacockSpiderBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue peacockSpiderKillingEntitySpawn;
        public final ForgeConfigSpec.BooleanValue bullfrogBreakingBlockSpawn;
        public final ForgeConfigSpec.BooleanValue bullfrogKillingEntitySpawn;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{" Options related to mob spawning", " Whether or not the mob will spawn when breaking blocks defined in json/[mobName]-spawn.json", " Whether or not the mob will spawn when killing entities defined in json/[mobName]-spawn.json"}).push("MobSpawning");
            builder.push("desert_mojo");
            this.desertMojoBreakingBlockSpawn = builder.define("Desert Mojo Breaking Block Spawn ", true);
            this.desertMojoKillingEntitySpawn = builder.define("Desert Mojo Killing Entity Spawn ", true);
            builder.pop();
            builder.push("forest_mojo");
            this.forestMojoBreakingBlockSpawn = builder.define("Forest Mojo Breaking Block Spawn ", true);
            this.forestMojoKillingEntitySpawn = builder.define("Forest Mojo Killing Entity Spawn ", true);
            builder.pop();
            builder.push("hound");
            this.houndBreakingBlockSpawn = builder.define("Hound Breaking Block Spawn ", true);
            this.houndKillingEntitySpawn = builder.define("Hound Killing Entity Spawn ", true);
            builder.pop();
            builder.push("Scarecrow");
            this.scarecrowBreakingBlockSpawn = builder.define("Scarecrow Breaking Block Spawn ", true);
            this.scarecrowKillingEntitySpawn = builder.define("Scarecrow Killing Entity Spawn ", true);
            builder.pop();
            builder.push("scorpion");
            this.scorpionBreakingBlockSpawn = builder.define("Scorpion Breaking Block Spawn ", true);
            this.scorpionKillingEntitySpawn = builder.define("Scorpion Killing Entity Spawn ", true);
            builder.pop();
            builder.push("scorpion_baby");
            this.scorpionBabyBreakingBlockSpawn = builder.define("Baby Scorpion Breaking Block Spawn ", true);
            this.scorpionBabyKillingEntitySpawn = builder.define("Baby Scorpion Killing Entity Spawn ", true);
            builder.pop();
            builder.push("wisp");
            this.wispBreakingBlockSpawn = builder.define("Wisp Breaking Block Spawn ", true);
            this.wispKillingEntitySpawn = builder.define("Wisp Killing Entity Spawn ", true);
            this.wispPurseXpReward = builder.define("Wisp Purse Xp Reward Range ", Arrays.asList(30, 30));
            builder.pop();
            builder.push("nether_wisp");
            this.netherWispBreakingBlockSpawn = builder.define("Nether Wisp Breaking Block Spawn ", true);
            this.netherWispKillingEntitySpawn = builder.define("Nether Wisp Killing Entity Spawn ", true);
            this.netherWispPurseXpReward = builder.define("Nether Wisp Purse Xp Reward Range ", Arrays.asList(80, 80));
            builder.pop();
            builder.push("ender_wisp");
            this.enderWispBreakingBlockSpawn = builder.define("Ender Wisp Breaking Block Spawn ", true);
            this.enderWispKillingEntitySpawn = builder.define("Ender Wisp Killing Entity Spawn ", true);
            this.enderWispPurseXpReward = builder.define("Ender Wisp Purse Xp Reward Range ", Arrays.asList(240, 240));
            builder.pop();
            builder.push("corpse_eater");
            this.corpseEaterBreakingBlockSpawn = builder.define("Corpse Eater Breaking Block Spawn ", true);
            this.corpseEaterKillingEntitySpawn = builder.define("Corpse Eater Killing Entity Spawn ", true);
            builder.pop();
            builder.push("peacock_spider");
            this.peacockSpiderBreakingBlockSpawn = builder.define("Peacock Spider Breaking Block Spawn ", true);
            this.peacockSpiderKillingEntitySpawn = builder.define("Peacock Spider Killing Entity Spawn ", true);
            builder.pop();
            builder.push("bullfrog");
            this.bullfrogBreakingBlockSpawn = builder.define("Bullfrog Breaking Block Spawn ", true);
            this.bullfrogKillingEntitySpawn = builder.define("Bullfrog Killing Entity Spawn ", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Baked {
        public static boolean desertMojoBreakingBlockSpawn;
        public static boolean desertMojoKillingEntitySpawn;
        public static boolean forestMojoBreakingBlockSpawn;
        public static boolean forestMojoKillingEntitySpawn;
        public static boolean houndBreakingBlockSpawn;
        public static boolean houndKillingEntitySpawn;
        public static boolean scarecrowBreakingBlockSpawn;
        public static boolean scarecrowKillingEntitySpawn;
        public static boolean scorpionBreakingBlockSpawn;
        public static boolean scorpionKillingEntitySpawn;
        public static boolean scorpionBabyBreakingBlockSpawn;
        public static boolean scorpionBabyKillingEntitySpawn;
        public static boolean wispBreakingBlockSpawn;
        public static boolean wispKillingEntitySpawn;
        public static List<Integer> wispPurseXpReward;
        public static boolean netherWispBreakingBlockSpawn;
        public static boolean netherWispKillingEntitySpawn;
        public static List<Integer> netherWispPurseXpReward;
        public static boolean enderWispBreakingBlockSpawn;
        public static boolean enderWispKillingEntitySpawn;
        public static List<Integer> enderWispPurseXpReward;
        public static boolean corpseEaterBreakingBlockSpawn;
        public static boolean corpseEaterKillingEntitySpawn;
        public static boolean peacockSpiderBreakingBlockSpawn;
        public static boolean peacockSpiderKillingEntitySpawn;
        public static boolean bullfrogBreakingBlockSpawn;
        public static boolean bullfrogKillingEntitySpawn;

        public static void bakeCommon() {
            try {
                desertMojoBreakingBlockSpawn = (Boolean)Config.COMMON.desertMojoBreakingBlockSpawn.get();
                desertMojoKillingEntitySpawn = (Boolean)Config.COMMON.desertMojoKillingEntitySpawn.get();
                forestMojoBreakingBlockSpawn = (Boolean)Config.COMMON.forestMojoBreakingBlockSpawn.get();
                forestMojoKillingEntitySpawn = (Boolean)Config.COMMON.forestMojoKillingEntitySpawn.get();
                houndBreakingBlockSpawn = (Boolean)Config.COMMON.houndBreakingBlockSpawn.get();
                houndKillingEntitySpawn = (Boolean)Config.COMMON.houndKillingEntitySpawn.get();
                scarecrowBreakingBlockSpawn = (Boolean)Config.COMMON.scarecrowBreakingBlockSpawn.get();
                scarecrowKillingEntitySpawn = (Boolean)Config.COMMON.scarecrowKillingEntitySpawn.get();
                scorpionBreakingBlockSpawn = (Boolean)Config.COMMON.scorpionBreakingBlockSpawn.get();
                scorpionKillingEntitySpawn = (Boolean)Config.COMMON.scorpionKillingEntitySpawn.get();
                scorpionBabyBreakingBlockSpawn = (Boolean)Config.COMMON.scorpionBabyBreakingBlockSpawn.get();
                scorpionBabyKillingEntitySpawn = (Boolean)Config.COMMON.scorpionBabyKillingEntitySpawn.get();
                wispBreakingBlockSpawn = (Boolean)Config.COMMON.wispBreakingBlockSpawn.get();
                wispKillingEntitySpawn = (Boolean)Config.COMMON.wispKillingEntitySpawn.get();
                wispPurseXpReward = (List)Config.COMMON.wispPurseXpReward.get();
                netherWispBreakingBlockSpawn = (Boolean)Config.COMMON.netherWispBreakingBlockSpawn.get();
                netherWispKillingEntitySpawn = (Boolean)Config.COMMON.netherWispKillingEntitySpawn.get();
                netherWispPurseXpReward = (List)Config.COMMON.netherWispPurseXpReward.get();
                enderWispBreakingBlockSpawn = (Boolean)Config.COMMON.enderWispBreakingBlockSpawn.get();
                enderWispKillingEntitySpawn = (Boolean)Config.COMMON.enderWispKillingEntitySpawn.get();
                enderWispPurseXpReward = (List)Config.COMMON.enderWispPurseXpReward.get();
                corpseEaterBreakingBlockSpawn = (Boolean)Config.COMMON.corpseEaterBreakingBlockSpawn.get();
                corpseEaterKillingEntitySpawn = (Boolean)Config.COMMON.corpseEaterKillingEntitySpawn.get();
                peacockSpiderBreakingBlockSpawn = (Boolean)Config.COMMON.peacockSpiderBreakingBlockSpawn.get();
                peacockSpiderKillingEntitySpawn = (Boolean)Config.COMMON.peacockSpiderKillingEntitySpawn.get();
                bullfrogBreakingBlockSpawn = (Boolean)Config.COMMON.bullfrogBreakingBlockSpawn.get();
                bullfrogKillingEntitySpawn = (Boolean)Config.COMMON.bullfrogKillingEntitySpawn.get();
            }
            catch (Exception e) {
                LegendaryCreatures.LOGGER.warn("An exception was caused trying to load the common config for Survival Overhaul");
                e.printStackTrace();
            }
        }
    }
}

