/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig.core.events;

import com.uraneptus.snowpig.client.entity.render.SnowPigRender;
import com.uraneptus.snowpig.core.ModIntegrations;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.registry.SPItems;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowpig", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SPClientEvents {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SPEntityTypes.SNOW_PIG.get(), SnowPigRender::new);
    }

    @SubscribeEvent
    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        CreativeModeTab tab = event.getTab();
        if (tabKey == CreativeModeTabs.f_256839_) {
            SPClientEvents.addBefore(Items.f_42485_, SPItems.FROZEN_PORKCHOP, event);
        }
        if (tabKey == CreativeModeTabs.f_256731_) {
            SPClientEvents.addBefore(Items.f_42630_, SPItems.SNOW_PIG_EGG, event);
        }
        if (tabKey == CreativeModeTabs.f_256869_) {
            SPClientEvents.addAfter(Items.f_186363_, SPItems.MUSIC_DISC_FROSTY_SNIG, event);
        }
        if (ModIntegrations.IS_FD_LOADED.booleanValue()) {
            if (!ModIntegrations.IS_AD_LOADED.booleanValue() && tab == ModIntegrations.getFdTab()) {
                SPClientEvents.addBefore(ModIntegrations.getHam(), SPItems.FROZEN_HAM, event);
            }
        } else if (tabKey == CreativeModeTabs.f_256839_) {
            SPClientEvents.addAfter(Items.f_42486_, SPItems.FROZEN_HAM, event);
        }
    }

    private static void addBefore(Item before, Supplier<? extends ItemLike> inputItem, BuildCreativeModeTabContentsEvent event) {
        event.getEntries().putBefore((Object)before.m_7968_(), (Object)inputItem.get().m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addAfter(Item after, Supplier<? extends ItemLike> inputItem, BuildCreativeModeTabContentsEvent event) {
        event.getEntries().putAfter((Object)after.m_7968_(), (Object)inputItem.get().m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

