/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropdailyweather;

import cool.bot.botslib.util.RNG;
import cool.bot.botslib.util.Seasons;
import cool.bot.dewdropdailyweather.Config;
import cool.bot.dewdropdailyweather.DewDropDailyWeather;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TickEventHandler {
    public static List<WeatherEvent> schedule = TickEventHandler.updateSchedule(null);

    private static ArrayList<WeatherEvent> updateSchedule(ServerLevel level) {
        List<List<String>> pools;
        List<List<Integer>> weights;
        List<List<Integer>> timesRanges;
        ArrayList<Integer> times;
        ArrayList<WeatherEvent> trueSchedule = new ArrayList<WeatherEvent>(List.of());
        if (!DewDropDailyWeather.useSeasons || level == null) {
            times = new ArrayList<Integer>(List.copyOf(Config.weatherTimes));
            timesRanges = List.copyOf(Config.weatherRanges);
            weights = List.copyOf(Config.weatherWeights);
            pools = List.copyOf(Config.weatherOptions);
        } else {
            switch (Seasons.getSeason((Level)level)) {
                case SPRING: {
                    times = new ArrayList<Integer>(List.copyOf(Config.weatherTimesSpring));
                    timesRanges = List.copyOf(Config.weatherRangesSpring);
                    weights = List.copyOf(Config.weatherWeightsSpring);
                    pools = List.copyOf(Config.weatherOptionsSpring);
                    break;
                }
                case SUMMER: {
                    times = new ArrayList<Integer>(List.copyOf(Config.weatherTimesSummer));
                    timesRanges = List.copyOf(Config.weatherRangesSummer);
                    weights = List.copyOf(Config.weatherWeightsSummer);
                    pools = List.copyOf(Config.weatherOptionsSummer);
                    break;
                }
                case FALL: {
                    times = new ArrayList<Integer>(List.copyOf(Config.weatherTimesFall));
                    timesRanges = List.copyOf(Config.weatherRangesFall);
                    weights = List.copyOf(Config.weatherWeightsFall);
                    pools = List.copyOf(Config.weatherOptionsFall);
                    break;
                }
                case WINTER: {
                    times = new ArrayList<Integer>(List.copyOf(Config.weatherTimesWinter));
                    timesRanges = List.copyOf(Config.weatherRangesWinter);
                    weights = List.copyOf(Config.weatherWeightsWinter);
                    pools = List.copyOf(Config.weatherOptionsWinter);
                    break;
                }
                default: {
                    times = new ArrayList<Integer>(List.copyOf(Config.weatherTimes));
                    timesRanges = List.copyOf(Config.weatherRanges);
                    weights = List.copyOf(Config.weatherWeights);
                    pools = List.copyOf(Config.weatherOptions);
                }
            }
        }
        int events = times.size();
        for (int i = 0; i < events; ++i) {
            if (!timesRanges.isEmpty()) {
                times.set(i, (Integer)times.get(i) + RNG.irandRange((int)timesRanges.get(i).get(0), (int)timesRanges.get(i).get(1)));
            }
            List<String> cpool = pools.get(i);
            List<Integer> cweights = weights.get(i);
            String weatherType = (String)RNG.weightedChoice(cpool, cweights);
            trueSchedule.add(new WeatherEvent((Integer)times.get(i), weatherType));
        }
        trueSchedule.sort(Comparator.comparingInt(WeatherEvent::getTime));
        return trueSchedule;
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerLevel level = event.getServer().m_129783_();
            if (!level.m_46469_().m_46207_(GameRules.f_46150_) || !level.m_46469_().m_46207_(GameRules.f_46140_)) {
                if (Config.logSchedule) {
                    DewDropDailyWeather.LOGGER.info("Weather cycle or daylight is off, no forecast generated.");
                }
                return;
            }
            int dayTime = (int)level.m_46468_() % 24000;
            if (dayTime == 1) {
                schedule = TickEventHandler.updateSchedule(level);
                if (Config.logSchedule) {
                    TickEventHandler.logSchedule(schedule, level);
                }
            } else if (schedule.stream().anyMatch(weatherEvent -> weatherEvent.getTime() == dayTime)) {
                String weatherType = schedule.stream().filter(weatherEvent -> weatherEvent.getTime() == dayTime).findFirst().get().getWeather();
                if (Config.logSchedule) {
                    DewDropDailyWeather.LOGGER.info("Current Weather: {}", (Object)weatherType);
                }
                switch (weatherType) {
                    case "clear": {
                        level.m_8606_(0, Integer.MAX_VALUE, false, false);
                        break;
                    }
                    case "rain": {
                        level.m_8606_(0, Integer.MAX_VALUE, true, false);
                        break;
                    }
                    case "storm": {
                        level.m_8606_(0, Integer.MAX_VALUE, true, true);
                        break;
                    }
                    case "ignore": {
                        break;
                    }
                }
            }
        }
    }

    private static void logSchedule(List<WeatherEvent> schedule, ServerLevel level) {
        DewDropDailyWeather.LOGGER.info("Today's Forecast:");
        if (DewDropDailyWeather.useSeasons) {
            DewDropDailyWeather.LOGGER.info("Season: {}", (Object)Seasons.getSeason((Level)level));
        }
        for (WeatherEvent event : schedule) {
            DewDropDailyWeather.LOGGER.info("{}: {}", (Object)event.getTime(), (Object)event.getWeather());
        }
    }

    public static class WeatherEvent {
        public int time;
        public String weather;

        public int getTime() {
            return this.time;
        }

        public String getWeather() {
            return this.weather;
        }

        public WeatherEvent(int time, String weather) {
            this.time = time;
            this.weather = weather;
        }
    }
}

