/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropdailyweather;

import cool.bot.botslib.util.Compatibility;
import cool.bot.dewdropdailyweather.DewDropDailyWeather;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="dew_drop_daily_weather", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static List<Integer> weatherTimes;
    private static final int MIN_DAYTIME = 1;
    private static final int MAX_DAYTIME = 24000;
    private static final List<Integer> defaultWeatherTimes;
    private static final Predicate<Object> daytimeValidator;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEATHER_TIMES;
    public static List<List<Integer>> weatherRanges;
    private static final List<? extends List<? extends Integer>> defaultWeatherRanges;
    private static final Predicate<Object> weatherRangeValidator;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_RANGES;
    public static List<List<String>> weatherOptions;
    private static final List<String> VALID_WEATHER_OPTIONS;
    private static final Predicate<Object> weatherOptionValidator;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> WEATHER_OPTIONS;
    public static List<List<Integer>> weatherWeights;
    private static final Predicate<Object> weatherWeightsValidator;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_WEIGHTS;
    public static boolean logSchedule;
    public static final ForgeConfigSpec.BooleanValue LOG_SCHEDULE;
    public static boolean enableSeasons;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SEASONS;
    public static List<Integer> weatherTimesSpring;
    public static List<List<Integer>> weatherRangesSpring;
    public static List<List<String>> weatherOptionsSpring;
    public static List<List<Integer>> weatherWeightsSpring;
    public static List<Integer> weatherTimesSummer;
    public static List<List<Integer>> weatherRangesSummer;
    public static List<List<String>> weatherOptionsSummer;
    public static List<List<Integer>> weatherWeightsSummer;
    public static List<Integer> weatherTimesFall;
    public static List<List<Integer>> weatherRangesFall;
    public static List<List<String>> weatherOptionsFall;
    public static List<List<Integer>> weatherWeightsFall;
    public static List<Integer> weatherTimesWinter;
    public static List<List<Integer>> weatherRangesWinter;
    public static List<List<String>> weatherOptionsWinter;
    public static List<List<Integer>> weatherWeightsWinter;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEATHER_TIMES_SPRING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_RANGES_SPRING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> WEATHER_OPTIONS_SPRING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_WEIGHTS_SPRING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEATHER_TIMES_SUMMER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_RANGES_SUMMER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> WEATHER_OPTIONS_SUMMER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_WEIGHTS_SUMMER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEATHER_TIMES_FALL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_RANGES_FALL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> WEATHER_OPTIONS_FALL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_WEIGHTS_FALL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEATHER_TIMES_WINTER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_RANGES_WINTER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> WEATHER_OPTIONS_WINTER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<? extends Integer>>> WEATHER_WEIGHTS_WINTER;
    static final ForgeConfigSpec SERVER_CONFIG;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        weatherTimes = (List)WEATHER_TIMES.get();
        weatherRanges = (List)WEATHER_RANGES.get();
        weatherOptions = (List)WEATHER_OPTIONS.get();
        weatherWeights = (List)WEATHER_WEIGHTS.get();
        logSchedule = (Boolean)LOG_SCHEDULE.get();
        enableSeasons = (Boolean)ENABLE_SEASONS.get();
        weatherTimesSpring = (List)WEATHER_TIMES_SPRING.get();
        weatherRangesSpring = (List)WEATHER_RANGES_SPRING.get();
        weatherOptionsSpring = (List)WEATHER_OPTIONS_SPRING.get();
        weatherWeightsSpring = (List)WEATHER_WEIGHTS_SPRING.get();
        weatherTimesSummer = (List)WEATHER_TIMES_SUMMER.get();
        weatherRangesSummer = (List)WEATHER_RANGES_SUMMER.get();
        weatherOptionsSummer = (List)WEATHER_OPTIONS_SUMMER.get();
        weatherWeightsSummer = (List)WEATHER_WEIGHTS_SUMMER.get();
        weatherTimesFall = (List)WEATHER_TIMES_FALL.get();
        weatherRangesFall = (List)WEATHER_RANGES_FALL.get();
        weatherOptionsFall = (List)WEATHER_OPTIONS_FALL.get();
        weatherWeightsFall = (List)WEATHER_WEIGHTS_FALL.get();
        weatherTimesWinter = (List)WEATHER_TIMES_WINTER.get();
        weatherRangesWinter = (List)WEATHER_RANGES_WINTER.get();
        weatherOptionsWinter = (List)WEATHER_OPTIONS_WINTER.get();
        weatherWeightsWinter = (List)WEATHER_WEIGHTS_WINTER.get();
        DewDropDailyWeather.useSeasons = enableSeasons && Compatibility.sereneSeasonsLoaded();
    }

    static {
        defaultWeatherTimes = List.of(Integer.valueOf(20), Integer.valueOf(14000));
        daytimeValidator = o -> o instanceof Integer && (Integer)o >= 1 && (Integer)o <= 24000;
        WEATHER_TIMES = BUILDER.comment("This is a list of when the mod should attempt to start a new weather event in ticks (DayTime)\nValues must be between 1 and 24000 (inclusive)\nDefault is [20, 14000]").defineList("weatherTimes", defaultWeatherTimes, daytimeValidator);
        defaultWeatherRanges = List.of(List.of(Integer.valueOf(0), Integer.valueOf(0)), List.of(Integer.valueOf(0), Integer.valueOf(2000)));
        weatherRangeValidator = o -> o instanceof List && ((List)o).size() == 2 && ((List)o).get(0) instanceof Integer && ((List)o).get(1) instanceof Integer && (Integer)((List)o).get(0) <= (Integer)((List)o).get(1) && (Integer)((List)o).get(0) >= -24000 && (Integer)((List)o).get(1) <= 24000;
        WEATHER_RANGES = BUILDER.comment("This is a list of lists, with a minimum and maximum value for random variance in weather Times, this list should be the same length as weatherTimes.\nExample: a Weather Time of 12000 with a corresponding Weather Range of [-1000, 1000] will result in a Weather Time randomly being selected between 11000 and 13000 each day.\nValues must be between -24000 and 24000 (inclusive), extreme values may result in the event not happening at all.\nDefault value: [[0,0],[0,2000]]").defineListAllowEmpty("weatherRanges", defaultWeatherRanges, weatherRangeValidator);
        VALID_WEATHER_OPTIONS = List.of("ignore", "clear", "rain", "storm");
        weatherOptionValidator = o -> {
            if (!(o instanceof List)) {
                return false;
            }
            for (Object option : (List)o) {
                if (!(option instanceof String)) {
                    return false;
                }
                if (VALID_WEATHER_OPTIONS.contains((String)option)) continue;
                return false;
            }
            return true;
        };
        WEATHER_OPTIONS = BUILDER.comment("This list of lists defines weather options that can be applied to a weather event, this list should be the same length as weatherTimes.\nValid Events are: \"clear\", \"rain\", \"storm\", \"ignore\"\nthe first three behave as you would expect from vanilla weather, ignore does nothing, allowing the current weather event to continue uninterrupted.\nDefault value: [[\"clear\", \"rain\", \"storm\"],[\"ignore\", \"clear\", \"rain\", \"storm\"]]").defineList("weatherOptions", List.of(List.of("clear", "rain", "storm"), List.of("ignore", "clear", "rain", "storm")), weatherOptionValidator);
        weatherWeightsValidator = o -> {
            if (!(o instanceof List)) {
                return false;
            }
            for (Object weight : (List)o) {
                if (!(weight instanceof Integer)) {
                    return false;
                }
                if ((Integer)weight > 0) continue;
                return false;
            }
            return true;
        };
        WEATHER_WEIGHTS = BUILDER.comment("This list of lists defines the weights of each weather event, this list should be the same length as weatherTimes, each sublist should be the same length as the corresponding Weather Options.\nValues must be above 0\nDefault value: [[7,2,1],[7,1,1,1]]").defineList("weatherWeights", List.of(List.of(Integer.valueOf(7), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(7), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1))), weatherWeightsValidator);
        LOG_SCHEDULE = BUILDER.comment("When enabled, print the scheduled weather events to server console at the beginning of the day, and the current event when a new event starts (including ignore events)").define("logSchedule", false);
        ENABLE_SEASONS = BUILDER.comment("If Serene Seasons is present, you can enable this to use an alternative set of lists for each season, these options work the same as the ones listed above and have identical default values.").define("enableSeasons", false);
        WEATHER_TIMES_SPRING = BUILDER.comment("Spring weather times").defineList("weatherTimesSpring", defaultWeatherTimes, daytimeValidator);
        WEATHER_RANGES_SPRING = BUILDER.comment("Spring weather ranges").defineListAllowEmpty("weatherRangesSpring", defaultWeatherRanges, weatherRangeValidator);
        WEATHER_OPTIONS_SPRING = BUILDER.comment("Spring weather options").defineList("weatherOptionsSpring", List.of(List.of("clear", "rain", "storm"), List.of("ignore", "clear", "rain", "storm")), weatherOptionValidator);
        WEATHER_WEIGHTS_SPRING = BUILDER.comment("Spring weather weights").defineList("weatherWeightsSpring", List.of(List.of(Integer.valueOf(7), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(7), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1))), weatherWeightsValidator);
        WEATHER_TIMES_SUMMER = BUILDER.comment("Summer weather times").defineList("weatherTimesSummer", defaultWeatherTimes, daytimeValidator);
        WEATHER_RANGES_SUMMER = BUILDER.comment("Summer weather ranges").defineListAllowEmpty("weatherRangesSummer", defaultWeatherRanges, weatherRangeValidator);
        WEATHER_OPTIONS_SUMMER = BUILDER.comment("Summer weather options").defineList("weatherOptionsSummer", List.of(List.of("clear", "rain", "storm"), List.of("ignore", "clear", "rain", "storm")), weatherOptionValidator);
        WEATHER_WEIGHTS_SUMMER = BUILDER.comment("Summer weather weights").defineList("weatherWeightsSummer", List.of(List.of(Integer.valueOf(7), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(7), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1))), weatherWeightsValidator);
        WEATHER_TIMES_FALL = BUILDER.comment("Fall weather times").defineList("weatherTimesFall", defaultWeatherTimes, daytimeValidator);
        WEATHER_RANGES_FALL = BUILDER.comment("Fall weather ranges").defineListAllowEmpty("weatherRangesFall", defaultWeatherRanges, weatherRangeValidator);
        WEATHER_OPTIONS_FALL = BUILDER.comment("Fall weather options").defineList("weatherOptionsFall", List.of(List.of("clear", "rain", "storm"), List.of("ignore", "clear", "rain", "storm")), weatherOptionValidator);
        WEATHER_WEIGHTS_FALL = BUILDER.comment("Fall weather weights").defineList("weatherWeightsFall", List.of(List.of(Integer.valueOf(7), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(7), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1))), weatherWeightsValidator);
        WEATHER_TIMES_WINTER = BUILDER.comment("Winter weather times").defineList("weatherTimesWinter", defaultWeatherTimes, daytimeValidator);
        WEATHER_RANGES_WINTER = BUILDER.comment("Winter weather ranges").defineListAllowEmpty("weatherRangesWinter", defaultWeatherRanges, weatherRangeValidator);
        WEATHER_OPTIONS_WINTER = BUILDER.comment("Winter weather options").defineList("weatherOptionsWinter", List.of(List.of("clear", "rain", "storm"), List.of("ignore", "clear", "rain", "storm")), weatherOptionValidator);
        WEATHER_WEIGHTS_WINTER = BUILDER.comment("Winter weather weights").defineList("weatherWeightsWinter", List.of(List.of(Integer.valueOf(7), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(7), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1))), weatherWeightsValidator);
        SERVER_CONFIG = BUILDER.build();
    }
}

