/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.packet;

import com.ninni.species.server.block.entity.BirtdayCakeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBirtdayCakeDataPacket {
    private final BlockPos pos;
    private final String name;
    private final int age;

    public UpdateBirtdayCakeDataPacket(BlockPos pos, String name, int age) {
        this.pos = pos;
        this.name = name;
        this.age = age;
    }

    public static void write(UpdateBirtdayCakeDataPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130070_(packet.name);
        buf.writeInt(packet.age);
    }

    public static UpdateBirtdayCakeDataPacket read(FriendlyByteBuf buf) {
        return new UpdateBirtdayCakeDataPacket(buf.m_130135_(), buf.m_130277_(), buf.readInt());
    }

    public static void handle(UpdateBirtdayCakeDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(packet.pos);
            if (blockEntity instanceof BirtdayCakeBlockEntity) {
                BirtdayCakeBlockEntity cake = (BirtdayCakeBlockEntity)blockEntity;
                cake.setPlayerName(packet.name);
                cake.setAge(packet.age);
                blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

