/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_3.Hanger;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.joml.Vector3f;

public class CliffHanger
extends Hanger {
    public static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.m_135353_(CliffHanger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_UPWARDS = SynchedEntityData.m_135353_(CliffHanger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public CliffHanger(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, true));
        this.f_21345_.m_25352_(0, (Goal)new SwitchGravityGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PullTowardsMouthGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CeilingTargetingGoal(this, 1.5, entity -> (entity.m_6095_().m_204039_(SpeciesTags.CLIFF_HANGER_PREY) || entity instanceof Player) && this.m_6779_((LivingEntity)entity) && entity.m_6084_() && !entity.m_5833_()));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 4.0f, 1.0, 1.25, livingEntity -> !this.isAttached()));
    }

    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            boolean flag;
            ServerLevel level2 = (ServerLevel)level;
            this.setAttached(this.f_19863_ && this.m_20184_().f_82480_ >= 0.0);
            if (!this.isAttached() && !this.isGoingUpwards() && this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_() < 0.0) {
                this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22100_(0.08);
            }
            boolean bl = flag = this.f_19796_.m_188501_() < 0.02f && this.isAttached() || this.f_19796_.m_188501_() < 0.3f && this.isTongueOut();
            if (flag) {
                level2.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.FALLING_HANGER_SALIVA.get()), this.m_20208_(1.5), this.m_20186_() + (double)this.getTongueOffset(), this.m_20262_(1.5), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void unstuckTarget() {
        Axolotl axolotl;
        LivingEntity livingEntity;
        super.unstuckTarget();
        if (this.isAttached() && (double)this.getTargetPos().y > this.m_20186_() + (double)this.getTongueOffset() + 0.5 && this.isTongueOut() && !this.isGoingUpwards() || (livingEntity = this.m_5448_()) instanceof Axolotl && (axolotl = (Axolotl)livingEntity).m_149175_()) {
            this.deactivateTongue();
            this.m_6710_(null);
            this.setCantAttackTicks(40);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Projectile) {
            amount *= 3.0f;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.HANGER_CRIT.get()), this.m_20185_(), (this.isAttached() ? this.m_20186_() + (double)this.m_20206_() - (double)0.1f : this.m_20186_() + (double)0.1f) - (double)(this.f_19796_.m_188501_() / 100.0f), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isTongueOut() || this.isAttached()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        super.m_7023_(vec3);
    }

    @Override
    public float getTongueOffset() {
        if (this.f_19804_.m_285897_(ATTACHED)) {
            return this.isAttached() ? 1.2f : super.getTongueOffset();
        }
        return super.getTongueOffset();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACHED, (Object)false);
        this.f_19804_.m_135372_(GOING_UPWARDS, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("Attached", this.isAttached());
        compoundTag.m_128379_("GoingUpwards", this.isGoingUpwards());
        super.m_7380_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        this.setAttached(compoundTag.m_128471_("Attached"));
        this.setGoingUpwards(compoundTag.m_128471_("GoingUpwards"));
        super.m_7378_(compoundTag);
    }

    public boolean isAttached() {
        return (Boolean)this.f_19804_.m_135370_(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.f_19804_.m_135381_(ATTACHED, (Object)attached);
    }

    public boolean isGoingUpwards() {
        return (Boolean)this.f_19804_.m_135370_(GOING_UPWARDS);
    }

    public void setGoingUpwards(boolean goingUpwards) {
        this.f_19804_.m_135381_(GOING_UPWARDS, (Object)goingUpwards);
    }

    @Override
    public boolean m_6094_() {
        return !this.isAttached() && super.m_6094_();
    }

    public int m_8100_() {
        return this.isAttached() ? 400 : super.m_8100_();
    }

    public static boolean canSpawn(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return levelAccessor.m_45517_(LightLayer.BLOCK, blockPos) == 0 && levelAccessor.m_45517_(LightLayer.SKY, blockPos) == 0 && levelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(SpeciesTags.CLIFF_HANGER_SPAWNABLE_ON) && levelAccessor.m_8055_(blockPos.m_7495_()).m_60643_((BlockGetter)levelAccessor, blockPos, entityType) && levelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    public boolean m_7327_(Entity target) {
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_ATTACK.get(), this.m_5720_(), 1.0f, 1.0f);
        return super.m_7327_(target);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_5448_() != null && this.isTongueOut() ? (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_IDLE_PULLING.get() : (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_STEP.get(), 0.15f, this.m_6100_());
    }

    public static class SwitchGravityGoal
    extends Goal {
        private final CliffHanger cliffHanger;
        private BlockPos targetCeilingPos = null;
        private boolean navigatingToCeiling = false;
        private int stuckTicks;

        public SwitchGravityGoal(CliffHanger cliffHanger) {
            this.cliffHanger = cliffHanger;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.cliffHanger.isAttached() && !this.cliffHanger.isTongueOut() && this.cliffHanger.m_21573_().m_26571_() && this.cliffHanger.f_19796_.m_188503_(20) == 0;
        }

        public void m_8056_() {
            Vec3 mobCenter = this.cliffHanger.m_20182_();
            BlockHitResult hit = this.raycastCeiling(mobCenter);
            if (hit.m_6662_() != HitResult.Type.BLOCK) {
                hit = this.searchForNearbyCeiling(mobCenter, 15.0);
            }
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                this.targetCeilingPos = BlockPos.m_274446_((Position)hit.m_82450_());
                this.navigatingToCeiling = true;
                BlockPos.MutableBlockPos walkTarget = this.targetCeilingPos.m_122032_();
                while (walkTarget.m_123342_() > this.cliffHanger.m_9236_().m_141937_() && this.cliffHanger.m_9236_().m_8055_(walkTarget.m_7495_()).m_60795_()) {
                    walkTarget.m_122173_(Direction.DOWN);
                }
                this.cliffHanger.m_21573_().m_26519_((double)walkTarget.m_123341_() + 0.5, (double)(walkTarget.m_123342_() + 1), (double)walkTarget.m_123343_() + 0.5, 1.0);
            } else {
                Vec3 randomPos = mobCenter.m_82520_(this.cliffHanger.f_19796_.m_188583_() * 5.0, 0.0, this.cliffHanger.f_19796_.m_188583_() * 5.0);
                this.cliffHanger.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, 1.0);
                this.navigatingToCeiling = false;
            }
        }

        public void m_8037_() {
            if (this.navigatingToCeiling && this.cliffHanger.m_20184_().m_165925_() < 0.1) {
                ++this.stuckTicks;
            }
            if (this.stuckTicks > 100) {
                this.cliffHanger.m_21573_().m_26569_();
            }
            if (this.navigatingToCeiling && this.targetCeilingPos != null) {
                BlockPos.MutableBlockPos walkTarget = this.targetCeilingPos.m_122032_();
                while (walkTarget.m_123342_() > this.cliffHanger.m_9236_().m_141937_() && this.cliffHanger.m_9236_().m_8055_(walkTarget.m_7495_()).m_60795_()) {
                    walkTarget.m_122173_(Direction.DOWN);
                }
                this.cliffHanger.m_21573_().m_26519_((double)walkTarget.m_123341_() + 0.5, (double)(walkTarget.m_123342_() + 1), (double)walkTarget.m_123343_() + 0.5, 1.0);
                double distanceSq = this.cliffHanger.m_20238_(Vec3.m_82512_((Vec3i)this.targetCeilingPos).m_193103_(Direction.Axis.Y, this.cliffHanger.m_20182_().f_82480_));
                if (distanceSq < 2.0 && this.cliffHanger.m_21573_().m_26571_()) {
                    this.cliffHanger.setGoingUpwards(true);
                    this.cliffHanger.m_216990_((SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_SHOOT.get());
                    this.cliffHanger.activateTongue(Vec3.m_82539_((Vec3i)this.targetCeilingPos.m_7494_()).m_252839_());
                    this.navigatingToCeiling = false;
                }
            }
            if (this.cliffHanger.isGoingUpwards()) {
                if (this.cliffHanger.f_19797_ % 15 == 0) {
                    this.cliffHanger.m_5496_((SoundEvent)SpeciesSoundEvents.HANGER_PULL.get(), 1.0f, 1.0f);
                }
                this.cliffHanger.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22100_(-0.04);
                if (this.cliffHanger.m_20186_() > (double)this.cliffHanger.getTargetPos().y) {
                    this.cliffHanger.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22100_(0.08);
                    this.m_8041_();
                }
            }
        }

        public boolean m_8045_() {
            return (this.navigatingToCeiling || this.cliffHanger.isGoingUpwards()) && !this.cliffHanger.isAttached();
        }

        public void m_8041_() {
            if (this.cliffHanger.isGoingUpwards()) {
                this.cliffHanger.setGoingUpwards(false);
                this.cliffHanger.deactivateTongue();
                this.cliffHanger.m_216990_((SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_ATTACH.get());
            }
            this.navigatingToCeiling = false;
            this.targetCeilingPos = null;
        }

        private BlockHitResult raycastCeiling(Vec3 origin) {
            BlockHitResult clip = this.cliffHanger.m_9236_().m_45547_(new ClipContext(origin.m_82520_(0.0, (double)this.cliffHanger.m_20206_(), 0.0), origin.m_82520_(0.0, 50.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.cliffHanger));
            if (clip.m_82425_().m_123342_() < this.cliffHanger.m_20183_().m_123342_() + 10) {
                return BlockHitResult.m_82426_((Vec3)origin, (Direction)this.cliffHanger.m_6350_(), (BlockPos)BlockPos.m_274446_((Position)origin));
            }
            return clip;
        }

        private BlockHitResult searchForNearbyCeiling(Vec3 center, double radius) {
            for (int angle = 0; angle < 360; angle += 15) {
                double offsetZ;
                double radians = Math.toRadians(angle);
                double offsetX = Math.cos(radians) * radius;
                Vec3 searchPos = center.m_82520_(offsetX, 0.0, offsetZ = Math.sin(radians) * radius);
                BlockHitResult result = this.raycastCeiling(searchPos);
                if (result.m_6662_() != HitResult.Type.BLOCK) continue;
                return result;
            }
            return BlockHitResult.m_82426_((Vec3)center, (Direction)this.cliffHanger.m_6350_(), (BlockPos)BlockPos.m_274446_((Position)center));
        }
    }

    public static class PullTowardsMouthGoal
    extends Goal {
        private final CliffHanger cliffHanger;

        public PullTowardsMouthGoal(CliffHanger cliffHanger) {
            this.cliffHanger = cliffHanger;
        }

        public boolean m_8036_() {
            return this.cliffHanger.isAttached() && !this.cliffHanger.isGoingUpwards() && this.cliffHanger.m_5448_() != null && !this.cliffHanger.m_5448_().m_20159_() && this.cliffHanger.getCantAttackTicks() == 0 && this.cliffHanger.m_5448_().m_20096_() && this.cliffHanger.m_5448_().m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.cliffHanger.setTongueOut(true);
            this.cliffHanger.m_9236_().m_6263_(null, this.cliffHanger.m_5448_().m_20185_(), this.cliffHanger.m_5448_().m_20186_(), this.cliffHanger.m_5448_().m_20189_(), (SoundEvent)SpeciesSoundEvents.CLIFF_HANGER_SHOOT.get(), this.cliffHanger.m_5720_(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            LivingEntity target = this.cliffHanger.m_5448_();
            if (!this.cliffHanger.m_9236_().f_46443_) {
                if (target.m_20182_().f_82480_ < this.cliffHanger.m_20182_().f_82480_ - 1.0) {
                    AttributeInstance gravity = target.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                    Vec3 diff = this.cliffHanger.m_20182_().m_82520_(0.0, (double)this.cliffHanger.getTongueOffset(), 0.0).m_82546_(target.m_20182_());
                    diff = diff.m_82542_(0.05, 0.0, 0.05).m_82520_(0.0, 0.025, 0.0);
                    target.m_20256_(target.m_20184_().m_82549_(diff).m_82520_(0.0, gravity.m_22135_(), 0.0));
                    if (target.m_20184_().f_82480_ < 0.1) {
                        target.m_246865_(new Vec3(0.0, 0.1, 0.0));
                    }
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        player.m_20256_(player.m_20184_().m_82520_(0.0, 0.04, 0.0));
                        player.f_19864_ = true;
                    }
                }
                if (target.f_19797_ % 30 == 0) {
                    target.m_5496_((SoundEvent)SpeciesSoundEvents.HANGER_PULL.get(), 1.0f, 1.0f);
                }
                Vector3f visualTarget = target.m_20182_().m_82520_(0.0, (double)target.m_20206_(), 0.0).m_252839_();
                this.cliffHanger.setTargetPos(visualTarget);
                this.cliffHanger.setTongueTarget(visualTarget);
            }
        }

        public boolean m_8045_() {
            return this.cliffHanger.isAttached() && !this.cliffHanger.isGoingUpwards() && this.cliffHanger.m_5448_() != null && !this.cliffHanger.m_5448_().m_20159_() && this.cliffHanger.getCantAttackTicks() == 0 && this.cliffHanger.m_5448_().m_6084_();
        }

        public void m_8041_() {
            this.cliffHanger.deactivateTongue();
        }
    }

    public static class CeilingTargetingGoal
    extends Goal {
        private final CliffHanger cliffHanger;
        private final double horizontalRange;
        private final Predicate<LivingEntity> predicate;

        public CeilingTargetingGoal(CliffHanger cliffHanger, double horizontalRange, Predicate<LivingEntity> predicate) {
            this.cliffHanger = cliffHanger;
            this.horizontalRange = horizontalRange;
            this.predicate = predicate;
        }

        public boolean m_8036_() {
            int distance;
            if (!this.cliffHanger.isAttached() || this.cliffHanger.m_5448_() != null || this.cliffHanger.getCantAttackTicks() > 0) {
                return false;
            }
            BlockPos ceilingPos = this.cliffHanger.m_20183_();
            int maxDistance = 40;
            BlockPos.MutableBlockPos checkPos = ceilingPos.m_122032_();
            for (distance = 0; distance < maxDistance && this.cliffHanger.m_9236_().m_8055_((BlockPos)checkPos).m_60795_(); ++distance) {
                checkPos.m_122184_(0, -1, 0);
            }
            if (distance >= maxDistance) {
                return false;
            }
            double floorY = ceilingPos.m_123342_() - distance + 1;
            AABB box = new AABB(this.cliffHanger.m_20185_() - this.horizontalRange, floorY, this.cliffHanger.m_20189_() - this.horizontalRange, this.cliffHanger.m_20185_() + this.horizontalRange, this.cliffHanger.m_20186_(), this.cliffHanger.m_20189_() + this.horizontalRange);
            List potentialTargets = this.cliffHanger.m_9236_().m_6443_(LivingEntity.class, box, this.predicate);
            if (!potentialTargets.isEmpty()) {
                Mob mob;
                this.cliffHanger.m_6710_((LivingEntity)potentialTargets.get(0));
                Object e = potentialTargets.get(0);
                if (e instanceof Mob && ((mob = (Mob)e).m_5448_() == null || !mob.m_5448_().m_7306_((Entity)this.cliffHanger))) {
                    mob.m_6710_((LivingEntity)this.cliffHanger);
                }
                if ((e = potentialTargets.get(0)) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)e;
                    Advancement hangerAdvancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation("species", "species/v3/fall_for_hanger"));
                    if (hangerAdvancement != null) {
                        if (serverPlayer.m_8960_().m_135996_(hangerAdvancement).m_8193_()) {
                            SpeciesCriterion.FALL_FOR_HANGER_TWICE.trigger(serverPlayer);
                        } else {
                            SpeciesCriterion.FALL_FOR_HANGER.trigger(serverPlayer);
                        }
                    }
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.cliffHanger.m_5448_() != null && this.cliffHanger.m_5448_().m_6084_() && this.cliffHanger.isAttached() && this.cliffHanger.getCantAttackTicks() == 0;
        }

        public void m_8041_() {
            this.cliffHanger.m_6710_(null);
        }
    }
}

