/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob.update_3.CliffHangerModel;
import com.ninni.species.client.renderer.entity.HangerRenderer;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.entity.mob.update_3.CliffHanger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CliffHangerRenderer
extends HangerRenderer<CliffHanger, CliffHangerModel<CliffHanger>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("species", "textures/entity/hanger/cliff_hanger.png");
    public static final ResourceLocation TEXTURE_RARE = new ResourceLocation("species", "textures/entity/hanger/drip_hanger.png");

    public CliffHangerRenderer(EntityRendererProvider.Context context) {
        super(context, new CliffHangerModel(context.m_174023_(SpeciesEntityModelLayers.CLIFF_HANGER)), 0.5f);
    }

    public ResourceLocation getTextureLocation(CliffHanger entity) {
        return entity.isRare() ? TEXTURE_RARE : TEXTURE;
    }

    public void render(CliffHanger entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_COIL));
        Vec3 base = new Vec3(0.0, (double)entity.getTongueOffset(), 0.0);
        Vec3 tip = new Vec3(entity.getCurrentTonguePos());
        Vec3 direction = tip.m_82546_(base);
        double length = direction.m_82553_();
        if (!entity.m_6084_()) {
            return;
        }
        Vec3 dirNorm = direction.m_82541_();
        Vec3 up = Math.abs(dirNorm.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 right = dirNorm.m_82537_(up).m_82541_().m_82490_(0.3);
        Vec3 forward = dirNorm.m_82537_(right).m_82541_().m_82490_(0.3);
        poseStack.m_85836_();
        float vMax = (float)length;
        this.drawTongueQuad(poseStack, builder, base, tip, right, vMax, packedLight, 1.0f, 1.0f);
        this.drawTongueQuad(poseStack, builder, base, tip, forward, vMax, packedLight, 1.0f, 1.0f);
        if (entity.isAttached()) {
            poseStack.m_252880_(-0.4f, -0.8f, -0.4f);
            poseStack.m_85837_(tip.f_82479_, tip.f_82480_, tip.f_82481_);
            poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)Blocks.f_152588_.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN), poseStack, buffer, packedLight, OverlayTexture.f_118083_);
        } else {
            poseStack.m_252880_(-0.4f, 0.0f, -0.4f);
            poseStack.m_85837_(tip.f_82479_, tip.f_82480_, tip.f_82481_);
            poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            Minecraft.m_91087_().m_91289_().m_110912_(Blocks.f_152588_.m_49966_(), poseStack, buffer, packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
    }
}

