/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.network.protocol.ClientboundGoldRushPacket;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GoldRushHandler {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Table<ResourceKey<Level>, BlockPos, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            ServerLevel serverLevel;
            Player player;
            Level level;
            block11: {
                block10: {
                    if (event.getPlayer().m_150110_().f_35937_) {
                        return;
                    }
                    if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
                        return;
                    }
                    if (EnchantmentHelper.m_272262_((ItemStack)event.getPlayer().m_21205_())) {
                        return;
                    }
                    level = event.getLevel();
                    player = event.getPlayer();
                    if (!(level instanceof ServerLevel)) break block10;
                    serverLevel = (ServerLevel)level;
                    if (player instanceof ServerPlayer) break block11;
                }
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GoldRushInstance activeGoldRush = (GoldRushInstance)activeGoldRushes.get((Object)level.m_46472_(), (Object)event.getPos());
            if (activeGoldRush == null) {
                activeGoldRush = GoldRushHandler.rollForGoldRush(serverLevel, event.getPos(), event.getState(), serverPlayer).orElse(null);
            }
            if (activeGoldRush != null) {
                if (activeGoldRush.getDropCooldownTicks() <= 0) {
                    BlockPos pos = activeGoldRush.getPos();
                    LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)level.m_7702_(pos));
                    ResourceLocation lootTableId = activeGoldRush.getLootTable();
                    if (lootTableId != BuiltInLootTables.f_78712_) {
                        LootParams lootParams = lootParamsBuilder.m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287235_(LootContextParamSets.f_81421_);
                        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableId);
                        lootTable.m_287195_(lootParams).forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack));
                    }
                    activeGoldRush.setDropCooldownTicks(activeGoldRush.getTicksPerDrop());
                }
                event.setCanceled(true);
            }
        });
        Balm.getEvents().onTickEvent(TickType.ServerLevel, TickPhase.Start, level -> {
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.m_46472_()).values()) {
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
                goldRush.setDropCooldownTicks(goldRush.getDropCooldownTicks() - 1);
                if (goldRush.getTicksPassed() < goldRush.getMaxTicks()) continue;
                if (level.m_8055_(goldRush.getPos()).equals(goldRush.getInitialState())) {
                    level.m_46953_(goldRush.getPos(), true, (Entity)goldRush.getPlayer());
                }
                Balm.getNetworking().sendToAll(level.m_7654_(), (Object)new ClientboundGoldRushPacket(goldRush.getPos(), false));
            }
            activeGoldRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks());
        });
    }

    public static Optional<GoldRushInstance> rollForGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, false).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, recipe));
    }

    public static boolean isInGoldRush(ServerLevel level, BlockPos pos) {
        return activeGoldRushes.contains((Object)level.m_46472_(), (Object)pos);
    }

    public static Optional<GoldRushInstance> startGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, true).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, recipe));
    }

    public static GoldRushInstance startGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, GoldRushRecipe recipe) {
        GoldRushInstance activeGoldRush = new GoldRushInstance(pos, state, recipe.lootTable(), (int)Math.floor(20.0f * recipe.seconds()), recipe.maxDropsPerSecond() == -1.0f ? 0 : (int)Math.floor(20.0f / recipe.maxDropsPerSecond()), (Player)player);
        Balm.getNetworking().sendToTracking(level, pos, (Object)new ClientboundGoldRushPacket(pos, true));
        player.m_36220_(ModStats.goldRushesTriggered);
        activeGoldRushes.put((Object)level.m_46472_(), (Object)pos, (Object)activeGoldRush);
        return activeGoldRush;
    }

    private static Optional<GoldRushRecipe> rollRecipe(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, boolean force) {
        RecipeManager recipeManager = level.m_7465_();
        List recipes = recipeManager.m_44013_(ModRecipeTypes.goldRushRecipeType);
        ArrayList<GoldRushRecipe> candidates = new ArrayList<GoldRushRecipe>();
        float baseChance = LittleJoysConfig.getActive().goldRush.baseChance;
        float roll = random.m_188501_();
        for (GoldRushRecipe recipe : recipes) {
            if (!GoldRushHandler.isValidRecipeFor(recipe, level, pos, state, player) || !force && !(roll <= baseChance * recipe.chanceMultiplier())) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.m_216822_((RandomSource)random, candidates);
    }

    private static boolean isValidRecipeFor(GoldRushRecipe recipe, ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, state, (Player)player);
        return recipe.eventCondition().test(context);
    }
}

