/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.DigSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.recipe.DigSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class DigSpotHandler {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final String DIG_SPOT_COOLDOWN = "digSpotCooldown";

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, player -> {
            CompoundTag playerData = Balm.getHooks().getPersistentData((Player)player);
            CompoundTag littleJoysData = playerData.m_128469_("littlejoys");
            playerData.m_128365_("littlejoys", (Tag)littleJoysData);
            int cooldown = littleJoysData.m_128451_(DIG_SPOT_COOLDOWN);
            if (cooldown > 0) {
                littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, cooldown - 1);
            } else {
                ServerLevel level = (ServerLevel)player.m_9236_();
                PoiManager poiManager = level.m_8904_();
                BlockPos centerPos = DigSpotHandler.getOriginForNextSpawn((Player)player);
                int checkRange = LittleJoysConfig.getActive().digSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().digSpots.spawnDistance;
                Optional digSpotInRange = poiManager.m_27181_(it -> it.m_203656_(ModPoiTypeTags.DIG_SPOTS), centerPos, checkRange, PoiManager.Occupancy.ANY).findAny();
                if (digSpotInRange.isEmpty()) {
                    BlockPos surfacePos = DigSpotHandler.getVerticallyNearRandomOffsetPos(level, centerPos, spawnRange);
                    BlockPos aboveSurfacePos = surfacePos.m_7494_();
                    int totalSpots = ChunkLimitManager.get(level).getTotalDigSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().digSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.m_8055_(aboveSurfacePos).m_247087_()) {
                        littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (DigSpotHandler.createDigSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createDigSpot(ServerLevel level, BlockPos pos, ServerPlayer player) {
        return DigSpotHandler.findRecipe(level, pos, player).map(recipe -> {
            DigSpotHandler.createDigSpot(level, pos, recipe);
            return true;
        }).orElse(false);
    }

    public static void createDigSpot(ServerLevel level, BlockPos pos, DigSpotRecipe recipe) {
        level.m_7731_(pos, ModBlocks.digSpot.m_49966_(), 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DigSpotBlockEntity) {
            DigSpotBlockEntity digSpot = (DigSpotBlockEntity)blockEntity;
            digSpot.setRecipeId(recipe.identifier());
        }
        ChunkLimitManager.get(level).trackDigSpot(pos);
    }

    private static BlockPos getOriginForNextSpawn(Player player) {
        int projectForwardDistance = LittleJoysConfig.getActive().digSpots.projectForwardDistance;
        Direction forwardDirection = player.m_6350_();
        return player.m_20183_().m_5484_(forwardDirection, projectForwardDistance);
    }

    private static BlockPos getVerticallyNearRandomOffsetPos(ServerLevel level, BlockPos origin, int spawnRange) {
        BlockPos bestPos = null;
        int bestDist = Integer.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            int offsetX = random.m_188503_(spawnRange + spawnRange) - spawnRange;
            int offsetZ = random.m_188503_(spawnRange + spawnRange) - spawnRange;
            BlockPos randomOffsetPos = new BlockPos(origin.m_123341_() + offsetX, origin.m_123341_(), origin.m_123343_() + offsetZ);
            BlockPos surfacePos = level.m_5452_(Heightmap.Types.WORLD_SURFACE, randomOffsetPos).m_7495_();
            int surfaceDist = Math.abs(surfacePos.m_123342_() - origin.m_123342_());
            if (bestPos != null && surfaceDist >= bestDist) continue;
            bestPos = surfacePos;
            bestDist = surfaceDist;
        }
        return bestPos;
    }

    private static Optional<DigSpotRecipe> findRecipe(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RecipeManager recipeManager = level.m_7465_();
        List recipes = recipeManager.m_44013_(ModRecipeTypes.digSpotRecipeType);
        ArrayList<DigSpotRecipe> candidates = new ArrayList<DigSpotRecipe>();
        for (DigSpotRecipe recipe : recipes) {
            if (!DigSpotHandler.isValidRecipeFor(recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.m_216822_((RandomSource)random, candidates);
    }

    private static boolean isValidRecipeFor(DigSpotRecipe recipe, ServerLevel level, BlockPos pos, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, level.m_8055_(pos), (Player)player);
        return recipe.eventCondition().test(context);
    }

    public static Optional<DigSpotRecipe> recipeById(ServerLevel level, @Nullable ResourceLocation recipeId) {
        RecipeManager recipeManager = level.m_7465_();
        if (recipeId == null) {
            return Optional.empty();
        }
        Recipe recipe = recipeManager.m_44043_(recipeId).orElse(null);
        if (recipe instanceof DigSpotRecipe) {
            DigSpotRecipe digSpotRecipe = (DigSpotRecipe)recipe;
            return Optional.of(digSpotRecipe);
        }
        return Optional.empty();
    }

    public static void digSpotConsumed(Player player) {
        CompoundTag playerData = Balm.getHooks().getPersistentData(player);
        CompoundTag littleJoysData = playerData.m_128469_("littlejoys");
        playerData.m_128365_("littlejoys", (Tag)littleJoysData);
        littleJoysData.m_128405_(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.afterDiggingCooldownSeconds * 20.0f));
        player.m_36220_(ModStats.digSpotsDug);
    }
}

