/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.forge.mixin;

import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.Optional;
import net.blay09.mods.littlejoys.handler.FishingSpotHandler;
import net.blay09.mods.littlejoys.handler.FishingSpotHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TideFishingHook.class})
public abstract class TideFishingHookMixin
extends Entity
implements FishingSpotHolder {
    @Shadow(remap=false)
    private int nibble;
    @Shadow(remap=false)
    private int timeUntilLured;
    @Nullable
    private BlockPos littlejoys_fishingSpot;

    public TideFishingHookMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"catchingFish"}, at={@At(value="HEAD")}, remap=false)
    private void catchingFish(BlockPos pos, CallbackInfo ci) {
        try {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TideFishingHookMixin fishingSpotHolder = this;
                if (fishingSpotHolder.getFishingSpot().isEmpty() && this.timeUntilLured > 40) {
                    FishingSpotHandler.findFishingSpot(serverLevel, pos).ifPresent(fishingSpotPos -> {
                        fishingSpotHolder.setFishingSpot((BlockPos)fishingSpotPos);
                        int configuredTimeUntilLured = FishingSpotHandler.claimFishingSpot(serverLevel, fishingSpotPos);
                        if (configuredTimeUntilLured >= 0) {
                            this.timeUntilLured = Math.max(1, configuredTimeUntilLured);
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("LittleJoys crashed during catchingFish hook", e);
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/player/Player;)I"}, at={@At(value="RETURN")}, remap=false)
    private void retrieve(ItemStack itemStack, ServerLevel level, Player player, CallbackInfoReturnable<Integer> ci) {
        try {
            TideFishingHookMixin fishingSpotHolder = this;
            Optional<BlockPos> fishingSpot = fishingSpotHolder.getFishingSpot();
            if (fishingSpot.isPresent() && this.nibble > 0) {
                FishingSpotHandler.consumeFishingSpot(player, level, fishingSpot.get());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("LittleJoys crashed during retrieve hook", e);
        }
    }

    @Override
    public Optional<BlockPos> getFishingSpot() {
        return Optional.ofNullable(this.littlejoys_fishingSpot);
    }

    @Override
    public void setFishingSpot(BlockPos fishingSpot) {
        this.littlejoys_fishingSpot = fishingSpot;
    }

    @Override
    public Player littlejoys$getPlayerOwner() {
        return ((TideFishingHook)this).getPlayerOwner();
    }
}

