/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.forge.compat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.api.EventContext;
import net.blay09.mods.littlejoys.api.LittleJoysAPI;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GameStagesSupport {
    public GameStagesSupport() {
        LittleJoysAPI.registerEventCondition(new ResourceLocation("gamestages", "has_stage"), GameStageCondition.class, GameStageCondition.CODEC, GameStageCondition::fromNetwork);
    }

    public record GameStageCondition(String stage) implements EventCondition
    {
        public static final MapCodec<GameStageCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("stage").forGetter(GameStageCondition::stage)).apply((Applicative)instance, GameStageCondition::new));

        @Override
        public boolean test(EventContext context) {
            return GameStageHelper.hasStage((Player)context.player(), (String)this.stage);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130070_(this.stage);
        }

        public static GameStageCondition fromNetwork(FriendlyByteBuf buf) {
            String stage = buf.m_130277_();
            return new GameStageCondition(stage);
        }
    }
}

