/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;

public class Grid {
    private final int[][] map;
    private final int size;
    private MultiImage images;

    public Grid(int width, int height, int tileSize, MultiImage images) {
        this.map = new int[width][height];
        this.size = tileSize;
        this.images = images;
    }

    public Grid(int width, int height, int tileSize, List<Image> images) {
        this.map = new int[width][height];
        this.size = tileSize;
        this.images = new MultiImage(images);
    }

    public int tileSize() {
        return this.size;
    }

    public int width() {
        return this.map.length;
    }

    public int height() {
        return this.map[0].length;
    }

    public int get(Vec2 pos) {
        return this.map[(int)pos.f_82470_][(int)pos.f_82471_];
    }

    public int get(int x, int y) {
        return this.map[x][y];
    }

    public void set(Vec2 pos, int value) {
        this.map[(int)pos.f_82470_][(int)pos.f_82471_] = value;
    }

    public void set(int x, int y, int value) {
        this.map[x][y] = value;
    }

    public MultiImage getImages() {
        return this.images;
    }

    public void render(GuiGraphics graphics, int posX, int posY) {
        for (int x = 0; x < this.map.length; ++x) {
            for (int y = 0; y < this.map[x].length; ++y) {
                this.renderTile(graphics, posX, posY, x, y);
            }
        }
    }

    public boolean isIn(Vec2 pos) {
        return pos.f_82470_ >= 0.0f && pos.f_82471_ >= 0.0f && pos.f_82470_ < (float)this.width() && pos.f_82471_ < (float)this.height();
    }

    private void renderTile(GuiGraphics graphics, int posX, int posY, int x, int y) {
        this.images.setImage(this.map[x][y]);
        this.images.render(graphics, posX + x * this.size, posY + y * this.size);
    }
}

