/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.datagen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.util.TagRegistry;
import net.tejty.gamediscs.util.loot.ItemModifier;
import net.tejty.gamediscs.util.loot.ItemTagModifier;
import org.jetbrains.annotations.NotNull;

public class DiscLootModifierProvider
extends GlobalLootModifierProvider {
    private static float chance = 0.3f;

    public DiscLootModifierProvider(PackOutput output) {
        super(output, "gamediscs");
    }

    protected void start() {
        Map<String, Float> lootTables = DiscLootModifierProvider.getLootTableWithChance();
        HashMap<String, Object> mobDiscs = new HashMap<String, Object>();
        mobDiscs.put("bee", ItemRegistry.GAME_DISC_FLAPPY_BIRD.get());
        mobDiscs.put("slime", ItemRegistry.GAME_DISC_SLIME.get());
        mobDiscs.put("frog", ItemRegistry.GAME_DISC_FROGGIE.get());
        mobDiscs.put("rabbit", ItemRegistry.GAME_DISC_RABBIT.get());
        for (Map.Entry<String, Float> entry : lootTables.entrySet()) {
            String lootTable = entry.getKey();
            float chance = entry.getValue().floatValue();
            this.add("disc_from_" + lootTable, (IGlobalLootModifier)new ItemTagModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation(lootTable)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)chance).m_6409_()}, TagRegistry.Items.GAME_DISCS));
        }
        for (Map.Entry<String, Float> entry : mobDiscs.entrySet()) {
            String mobName = entry.getKey();
            Float gameDisc = entry.getValue();
            this.add("mob_drops/" + mobName + "_drops_game_disc", (IGlobalLootModifier)new ItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mobName)).m_6409_(), LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_).m_36662_()).m_6409_()}, (Item)gameDisc));
        }
    }

    @NotNull
    private static Map<String, Float> getLootTableWithChance() {
        HashMap<String, Float> lootTables = new HashMap<String, Float>();
        lootTables.put("chests/simple_dungeon", Float.valueOf(chance));
        lootTables.put("chests/stronghold_corridor", Float.valueOf(chance));
        lootTables.put("chests/stronghold_crossing", Float.valueOf(chance));
        lootTables.put("chests/stronghold_library", Float.valueOf(chance));
        lootTables.put("chests/end_city_treasure", Float.valueOf(chance));
        lootTables.put("chests/woodland_mansion", Float.valueOf(chance));
        lootTables.put("chests/buried_treasure", Float.valueOf(chance));
        lootTables.put("chests/ruined_portal", Float.valueOf(chance));
        lootTables.put("chests/ancient_city", Float.valueOf(chance));
        lootTables.put("chests/ancient_city_ice_box", Float.valueOf(chance));
        lootTables.put("chests/abandoned_mineshaft", Float.valueOf(chance));
        lootTables.put("chests/jungle_temple", Float.valueOf(chance));
        lootTables.put("chests/desert_pyramid", Float.valueOf(chance));
        lootTables.put("chests/bastion_bridge", Float.valueOf(chance));
        lootTables.put("chests/bastion_hoglin_stable", Float.valueOf(chance));
        lootTables.put("chests/bastion_other", Float.valueOf(chance));
        lootTables.put("chests/bastion_treasure", Float.valueOf(chance));
        return lootTables;
    }
}

