/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.rosemods.windswept.common.block.PineconeBlock;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PineTreeFeature
extends BlueprintTreeFeature {
    public PineTreeFeature() {
        super(TreeConfiguration.f_68184_);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        int y;
        BlockPos origin = context.m_159777_();
        RandomSource rand = context.m_225041_();
        boolean isWeathered = rand.m_188499_() || context.m_159774_().m_204166_(context.m_159777_()).m_203565_(Biomes.f_186763_);
        boolean isFairy = rand.m_188503_(3000) == 0;
        int height = rand.m_216339_(10, 14);
        int weatheredHeight = rand.m_216339_(7, height - 1);
        int weatheredHeightMin = rand.m_216339_(2, weatheredHeight - 2);
        BlockState weathered = ((Block)WindsweptBlocks.WEATHERED_PINE_LOG.get()).m_49966_();
        if (isFairy) {
            BlockState state = ((Block)WindsweptBlocks.NIGHTSHADE.get()).m_49966_();
            WorldGenLevel level = context.m_159774_();
            for (BlockPos pos : new BlockPos[]{origin.m_122013_(1), origin.m_122020_(1), origin.m_122030_(1), origin.m_122025_(1)}) {
                if (!state.m_60710_((LevelReader)level, pos)) continue;
                this.addSpecialFoliage(pos, state);
            }
        }
        if (isWeathered) {
            for (y = 0; y < weatheredHeightMin; ++y) {
                this.addLog(origin.m_6630_(y));
            }
            for (y = weatheredHeightMin; y < height; ++y) {
                if (y < weatheredHeight) {
                    this.addSpecialLog(origin.m_6630_(y), weathered);
                    continue;
                }
                this.addLog(origin.m_6630_(y));
            }
        } else {
            for (y = 0; y < height; ++y) {
                this.addLog(origin.m_6630_(y));
            }
        }
        ArrayList directions = Lists.newArrayList((Iterable)Direction.Plane.HORIZONTAL);
        ArrayList directions1 = Lists.newArrayList();
        for (Direction direction : directions) {
            if (rand.m_188503_(8) != 0) continue;
            BlockPos pos = origin.m_6630_(height - 2).m_5484_(direction, 3);
            directions1.add(direction);
            this.addFoliage(pos);
            this.addPinecones(pos.m_7495_(), rand.m_188503_(2) + 3, isFairy);
        }
        for (y = height - 4; y > 3; --y) {
            if (rand.m_188503_(4) <= 0) continue;
            Direction direction = (Direction)directions.get(rand.m_188503_(directions.size()));
            BlockPos pos = origin.m_6630_(y).m_121945_(direction);
            directions.remove(direction);
            if (y < weatheredHeight && isWeathered) {
                this.addSpecialLog(pos, weathered);
                this.addSpecialLog(pos.m_7495_(), weathered);
            } else {
                this.addLog(pos);
                this.addLog(pos.m_7495_());
            }
            this.addFoliage(pos.m_7494_());
            this.addFoliage(pos.m_7494_().m_121945_(direction));
            if (!directions1.contains(direction)) {
                BlockPos blockPos = pos.m_5484_(direction, 2);
                this.addFoliage(blockPos);
                this.addPinecones(blockPos.m_7495_(), rand.m_188503_(2) + 3, isFairy);
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.addFoliage(pos.m_7918_(x, 0, z));
                    if (rand.m_188503_(8) != 0) continue;
                    this.addPinecones(pos.m_7918_(x, -1, z), rand.m_188503_(2) + 1, isFairy);
                }
            }
            if (directions.isEmpty()) break;
        }
        if (rand.m_188503_(3) == 0) {
            this.addFoliage(origin.m_6630_(height + 1));
        }
        for (y = 1; y < 5; ++y) {
            int i = switch (y) {
                default -> y;
                case 3 -> 2;
                case 4 -> 1;
            };
            for (int x = -i; x <= i; ++x) {
                for (int z = -i; z <= i; ++z) {
                    int absZ;
                    int absX = Math.abs(x);
                    if (absX + (absZ = Math.abs(z)) > i && (absX != 1 || absZ != 1 || rand.m_188503_(8) != 0)) continue;
                    this.addFoliage(origin.m_7918_(x, height + 1 - y, z));
                }
            }
        }
    }

    private void addPinecones(BlockPos pos, int amount, boolean isFairy) {
        this.addSpecialFoliage(pos, (BlockState)((Block)(isFairy ? WindsweptBlocks.NIGHT_FAIRY_LIGHT : WindsweptBlocks.PINECONE).get()).m_49966_().m_61124_((Property)PineconeBlock.AMOUNT, (Comparable)Integer.valueOf(amount)));
    }

    public BlockState getSapling() {
        return ((Block)WindsweptBlocks.PINE_SAPLING.get()).m_49966_();
    }
}

