/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.item;

import com.rosemods.windswept.common.block.IWoodenBucketPickupBlock;
import com.rosemods.windswept.common.capability.wrappers.WoodenBucketWrapper;
import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.registry.WindsweptItems;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class WoodenBucketItem
extends BucketItem {
    public WoodenBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockhitresult = WoodenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = blockhitresult.m_82425_();
            Direction direction = blockhitresult.m_82434_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
                if (this.getFluid() == Fluids.f_76191_) {
                    IWoodenBucketPickupBlock pickup;
                    BlockState state = level.m_8055_(blockpos);
                    Block block = state.m_60734_();
                    if (block instanceof IWoodenBucketPickupBlock && (pickup = (IWoodenBucketPickupBlock)block).canPickupFromWoodenBucket((LevelAccessor)level, blockpos, state)) {
                        ItemStack filledBucket = WoodenBucketItem.getFilled(itemstack, (ItemLike)pickup.getWoodenBucketItem(state), player);
                        pickup.getWoodenBucketPickupSound(state).ifPresent(soundevent -> player.m_5496_(soundevent, 1.0f, 1.0f));
                        pickup.pickupBlockFromWoodenBucket((LevelAccessor)level, blockpos, state);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        level.m_142346_((Entity)player, GameEvent.f_157816_, blockpos);
                        if (!level.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, filledBucket);
                        }
                        return InteractionResultHolder.m_19092_((Object)filledBucket, (boolean)level.f_46443_);
                    }
                } else {
                    BlockPos blockpos2;
                    BlockState blockstate = level.m_8055_(blockpos);
                    BlockPos blockPos = blockpos2 = this.canBlockContainFluid(level, blockpos, blockstate) ? blockpos : blockpos1;
                    if (this.m_142073_(player, level, blockpos2, blockhitresult)) {
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos2, itemstack);
                        }
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        return InteractionResultHolder.m_19092_((Object)WoodenBucketItem.getEmpty(itemstack, player, hand), (boolean)level.f_46443_);
                    }
                }
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean isEmpty() {
        return this.getFluid() == Fluids.f_76191_;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)WindsweptConfig.COMMON.woodenBucketDurabilty.get();
    }

    public boolean isRepairable(ItemStack stack) {
        return this.getFluid() == Fluids.f_76191_;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> recipeType) {
        return this.isEmpty() ? 600 : super.getBurnTime(stack, recipeType);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return this.isEmpty() ? super.getCraftingRemainingItem(itemStack) : WoodenBucketItem.getEmpty(itemStack, null, null);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.isEmpty() ? EquipmentSlot.HEAD : null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new WoodenBucketWrapper(stack);
    }

    public static ItemStack getEmpty(ItemStack handStack, Player player, InteractionHand hand) {
        ItemStack bucket = new ItemStack((ItemLike)WindsweptItems.WOODEN_BUCKET.get());
        bucket.m_41721_(handStack.m_41773_());
        handStack.getAllEnchantments().forEach((arg_0, arg_1) -> ((ItemStack)bucket).m_41663_(arg_0, arg_1));
        if (player != null) {
            bucket.m_41622_(1, (LivingEntity)player, p -> {
                if (hand != null) {
                    p.m_21190_(hand);
                }
            });
            if (player.m_150110_().f_35937_) {
                return handStack;
            }
        } else if (bucket.m_220157_(1, RandomSource.m_216327_(), null)) {
            bucket.m_41764_(0);
        }
        return bucket;
    }

    public static ItemStack getFilled(ItemStack handStack, ItemLike filled, Player player) {
        ItemStack bucket = new ItemStack(filled);
        handStack.getAllEnchantments().forEach((arg_0, arg_1) -> ((ItemStack)bucket).m_41663_(arg_0, arg_1));
        if (player == null || !player.m_150110_().f_35937_) {
            bucket.m_41721_(handStack.m_41773_());
        }
        return player != null ? ItemUtils.m_41813_((ItemStack)handStack, (Player)player, (ItemStack)bucket) : bucket;
    }
}

