/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.rosemods.windswept.client.model.AntlerHelmetModel;
import com.rosemods.windswept.core.other.WindsweptTiers;
import com.rosemods.windswept.core.registry.WindsweptAttributes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class AntlerHelmetItem
extends ArmorItem {
    private static final UUID SPRINT_DAMAGE_UUID = UUID.fromString("e97abdf0-cd94-45f4-8cd4-581a0a75515f");
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("cd559dfd-c166-4043-b9eb-a69e85abb04b");

    public AntlerHelmetItem(Item.Properties properties) {
        super((ArmorMaterial)WindsweptTiers.ANTLER_HELMET, ArmorItem.Type.HELMET, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(slot));
        if (slot == this.f_265916_.m_266308_()) {
            builder.put((Object)((Attribute)WindsweptAttributes.SPRINT_DAMAGE.get()), (Object)new AttributeModifier(SPRINT_DAMAGE_UUID, "Sprint damage modifier", 4.0, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return AntlerHelmetModel.INSTANCE;
            }
        });
    }

    public static void removeSprintDamage(LivingEntity entity) {
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null && damage.m_22111_(ATTACK_DAMAGE_UUID) != null) {
            damage.m_22120_(ATTACK_DAMAGE_UUID);
        }
    }

    public static void tryAddSprintDamage(LivingEntity entity) {
        AttributeInstance damage;
        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)WindsweptItems.ANTLER_HELMET.get()) && entity.m_20142_() && (damage = entity.m_21051_(Attributes.f_22281_)) != null && damage.m_22111_(ATTACK_DAMAGE_UUID) == null) {
            damage.m_22118_(new AttributeModifier(ATTACK_DAMAGE_UUID, "Sprint damage boost", 4.0, AttributeModifier.Operation.ADDITION));
        }
    }
}

