/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerCapability
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
    }

    @Override
    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        int total = 0;
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack containerStack = itemHandler.getStackInSlot(i);
            if (!WandUtil.stackEquals(itemStack, containerStack)) continue;
            total += Math.max(0, containerStack.m_41613_());
        }
        return total;
    }

    @Override
    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        ItemStack extracted;
        ItemStack handlerStack;
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; !(i >= itemHandler.getSlots() || WandUtil.stackEquals(itemStack, handlerStack = itemHandler.getStackInSlot(i)) && (count -= (extracted = itemHandler.extractItem(i, count, false)).m_41613_()) <= 0); ++i) {
        }
        return count;
    }
}

