/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.particle.WeatherParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class CustomParticle
extends WeatherParticle {
    ModConfig.ParticleOptions opts;
    private float oCollisionAnimProgress = 1.0f;
    private float collisionAnimProgress = 1.0f;
    private float speed = 0.0f;
    private final float rotationVariation;

    public CustomParticle(ClientLevel level, double x, double y, double z, ModConfig.ParticleOptions opts) {
        super(level, x, y, z, opts.gravity, opts.opacity, opts.size, opts.windStrength, opts.stormWindStrength);
        this.opts = opts;
        this.f_107225_ = opts.lifetime;
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        this.m_108337_(particleEngine.getTextureAtlas().m_118316_(StonecutterUtil.parseResourceLocation(opts.spriteLocations.get(level.f_46441_.m_188503_(opts.spriteLocations.size())))));
        this.rotationVariation = opts.rotationAmount * ((this.f_107223_.m_188501_() - 0.5f) * 2.0f);
        this.f_107663_ = opts.constantScreenSize ? this.getDistanceSize() : opts.size;
        switch (opts.tintType) {
            case CUSTOM: {
                this.m_107253_((float)opts.customTint.getRed() / 255.0f, (float)opts.customTint.getGreen() / 255.0f, (float)opts.customTint.getBlue() / 255.0f);
                break;
            }
            case FOG: {
                Color color = new Color(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47539_()).darker();
                this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                break;
            }
            case WATER: {
                if (!ModConfig.CONFIG.compat.waterTint) break;
                TextureUtil.applyWaterTint(this, level, (BlockPos)this.pos);
                break;
            }
            case MAP: {
                Color color = StonecutterUtil.getMapColor(level, (BlockPos)this.pos);
                this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.speed = (float)new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82553_();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.f_107663_ = this.getDistanceSize();
        }
        if (this.opts.rotationAmount != 0.0f) {
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rotationVariation * this.speed;
        }
        this.tickWind();
    }

    public void tickWind() {
        float frequency = ModConfig.CONFIG.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ModConfig.CONFIG.wind.modulationSpeed;
        float variance = ModConfig.CONFIG.wind.strengthVariance;
        float strength = ModConfig.CONFIG.wind.strength;
        float multiplier = this.f_107208_.m_46470_() ? this.opts.stormWindStrength : this.opts.windStrength;
        this.f_107215_ = (double)((Mth.m_14031_((float)((float)this.f_107212_ * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.f_107213_);
        this.f_107217_ = (double)((Mth.m_14031_((float)((float)this.f_107214_ * frequency + shift)) * variance + variance + strength) * multiplier) * CustomParticle.yLevelWindAdjustment(this.f_107213_);
    }

    @Override
    public void onPositionUpdate() {
        super.onPositionUpdate();
        this.testForCollisions();
    }

    public void testForCollisions() {
        Vec3 quadEdgePos;
        Vec3 quadCenterPos;
        BlockHitResult hitResult;
        float length = this.f_107663_;
        if (this.opts.rotationType.equals((Object)ModConfig.RotationType.RELATIVE_VELOCITY)) {
            Vec3 camD = Minecraft.m_91087_().f_91075_.m_20184_();
            Vector3f deltaMotion = new Vector3f((float)(this.f_107215_ - camD.f_82479_), (float)(this.f_107216_ - camD.f_82480_), (float)(this.f_107217_ - camD.f_82481_));
            length *= Mth.m_14036_((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
        }
        if (!(hitResult = this.f_107208_.m_45547_(StonecutterUtil.getClipContext(quadCenterPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), quadEdgePos = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82541_().m_82542_((double)length, (double)length, (double)length).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_)))).m_6662_().equals((Object)HitResult.Type.MISS) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.oCollisionAnimProgress = this.collisionAnimProgress;
        this.collisionAnimProgress -= this.speed;
        if (!this.opts.rotationType.equals((Object)ModConfig.RotationType.RELATIVE_VELOCITY)) {
            this.f_107663_ -= this.speed;
        }
        if (this.oCollisionAnimProgress <= 0.0f) {
            this.m_107274_();
        }
    }

    public float getDistanceSize() {
        return this.distance * this.opts.size;
    }

    public ParticleRenderType m_7556_() {
        return switch (this.opts.renderType) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.RenderType.TRANSLUCENT -> ParticleRenderType.f_107431_;
            case ModConfig.RenderType.OPAQUE -> ParticleRenderType.f_107430_;
            case ModConfig.RenderType.TERRAIN -> ParticleRenderType.f_107429_;
            case ModConfig.RenderType.BLENDED -> BlendedParticleRenderType.INSTANCE;
        };
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickPercent) {
        Vec3 camPos = camera.m_90583_();
        float offsetX = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float offsetY = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float offsetZ = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        switch (this.opts.rotationType) {
            case COPY_CAMERA: {
                Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
                if (this.f_107231_ != 0.0f) {
                    quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
                }
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)java.lang.Math.PI));
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case RELATIVE_VELOCITY: {
                float collisionProg;
                Vec3 camD = Minecraft.m_91087_().f_91075_.m_20184_();
                Vector3f deltaMotion = new Vector3f((float)(this.f_107215_ - camD.f_82479_), (float)(this.f_107216_ - camD.f_82480_), (float)(this.f_107217_ - camD.f_82481_));
                float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
                Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
                Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
                Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
                transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
                float stretchFactor = Mth.m_14036_((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
                if (this.doCollisionAnim && (collisionProg = Mth.m_14179_((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
                    stretchFactor = collisionProg;
                }
                this.renderSquishyRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
                break;
            }
            case LOOKAT_PLAYER: {
                Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
                Quaternionf quaternion = Axis.f_252436_.m_252961_(Math.atan2((float)offsetX, (float)offsetZ) + (float)java.lang.Math.PI);
                float yAngle = Math.asin((float)(offsetY / localPos.length()));
                quaternion.rotateX(yAngle);
                quaternion.rotateZ(Math.atan2((float)offsetX, (float)offsetZ));
                if (yAngle < -1.0f) {
                    this.doCollisionAnim = true;
                }
                quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
                break;
            }
            case FLAT_PLANES: {
                Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
                quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
                this.turnBackfaceFlipways(quaternion, new Vector3f(offsetX, offsetY, offsetZ));
                this.renderRotatedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickPercent);
            }
        }
    }

    private void renderSquishyRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        float size = this.m_5902_(tickPercent);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int color = this.m_6355_(tickPercent);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, -squish, size, u1, v1, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, squish, size, u1, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, squish, size, u0, v0, color);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, -squish, size, u0, v1, color);
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        buffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        ModConfig.ParticleOptions opts;

        public DefaultFactory(ModConfig.ParticleOptions opts) {
            this.opts = opts;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            for (ModConfig.ParticleOptions options : ModConfig.CONFIG.customParticles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

