/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.tconstruct;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.DrainBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.DuctBlockEntity;
import snownee.jade.addon.tconstruct.CastingTableProvider;
import snownee.jade.addon.tconstruct.DuctFluidProvider;
import snownee.jade.addon.tconstruct.DuctItemProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;

public class TConstructPlugin
implements IWailaPlugin {
    public static final String ID = "jadeaddons.tconstruct";
    public static final ResourceLocation CASTING_TABLE = new ResourceLocation("jadeaddons.tconstruct", "casting_table");
    public static final ResourceLocation DUCT_FLUID = new ResourceLocation("jadeaddons.tconstruct", "duct_fluid");
    public static final ResourceLocation DUCT_ITEM = new ResourceLocation("jadeaddons.tconstruct", "duct_item");

    public void register(IWailaCommonRegistration registration) {
        registration.registerProgress((IServerExtensionProvider)CastingTableProvider.INSTANCE, CastingBlockEntity.class);
        registration.registerFluidStorage((IServerExtensionProvider)DuctFluidProvider.INSTANCE, DuctBlockEntity.class);
        registration.registerItemStorage((IServerExtensionProvider)DuctItemProvider.INSTANCE, DuctBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerProgressClient((IClientExtensionProvider)CastingTableProvider.INSTANCE);
        registration.registerFluidStorageClient((IClientExtensionProvider)DuctFluidProvider.INSTANCE);
        registration.registerItemStorageClient((IClientExtensionProvider)DuctItemProvider.INSTANCE);
        registration.addRayTraceCallback((hitResult, accessor, original) -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                BlockState state = blockAccessor.getBlockState();
                if (!(state.m_60734_() instanceof FaucetBlock)) {
                    return accessor;
                }
                BlockPos posRel = blockAccessor.getPosition().m_121945_(((Direction)state.m_61143_((Property)FaucetBlock.FACING)).m_122424_());
                BlockEntity beRel = accessor.getLevel().m_7702_(posRel);
                if (beRel instanceof DuctBlockEntity || beRel instanceof DrainBlockEntity) {
                    BlockState blockState = beRel.m_58900_();
                    BlockHitResult blockHitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)posRel), ((BlockHitResult)blockAccessor.getHitResult()).m_82434_(), posRel, true);
                    return registration.blockAccessor().from(blockAccessor).blockState(blockState).blockEntity(beRel).hit(blockHitResult).build();
                }
            }
            return accessor;
        });
    }
}

