/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class SPacketSyncAffixData {
    private final int entityId;
    private final ResourceLocation id;
    private final CompoundTag data;

    public SPacketSyncAffixData(int entityId, ResourceLocation id, CompoundTag data) {
        this.entityId = entityId;
        this.data = data;
        this.id = id;
    }

    public static void encode(SPacketSyncAffixData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130085_(msg.id);
        buf.m_130079_(msg.data);
    }

    public static SPacketSyncAffixData decode(FriendlyByteBuf buf) {
        return new SPacketSyncAffixData(buf.readInt(), buf.m_130281_(), buf.m_130260_());
    }

    public static void handle(SPacketSyncAffixData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null) {
                Entity entity = world.m_6815_(msg.entityId);
                ChampionCapability.getCapability(entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.getAffix(msg.id.toString()).ifPresent(affix -> affix.readSyncTag((IChampion)champion, msg.data));
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

