/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.integration.jade;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.ui.Element;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.util.HUDHelper;
import top.theillusivec4.champions.common.rank.Rank;

public class StarElement
extends Element {
    private final int starCount;
    private final int spacing;
    private final float r;
    private final float g;
    private final float b;

    StarElement(int starCount, String colorCode, int spacing) {
        int color = Rank.getColor(colorCode);
        this.starCount = starCount;
        this.spacing = spacing;
        this.r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    public static StarElement of(int starCount, String colorCode, int spacing) {
        return new StarElement(starCount, colorCode, spacing);
    }

    public ResourceLocation getTexture() {
        return HUDHelper.getGuiStar();
    }

    public Vec2 getSize() {
        return new Vec2((float)(this.starCount * 9 + (this.starCount - 1) * this.spacing), (float)(9 + ClientChampionsConfig.jadeStarBottomPadding));
    }

    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)1.0f);
        for (int i = 0; i < this.starCount; ++i) {
            guiGraphics.m_280163_(this.getTexture(), (int)(x + (float)(i * (9 + this.spacing))), (int)y, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

