/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.trades.MyWandererTrade;

public class WandererTradeCollection {
    public transient String source = "Local Config file";
    public String profession;
    public boolean removeOtherTrades = false;
    public int maxCommonTrades = 5;
    public int maxRareTrades = 1;
    public MyWandererTrade[] trades;

    public int numberOfGenericTrades() {
        int count = 0;
        for (MyWandererTrade t : this.trades) {
            if (t.isRare) continue;
            ++count;
        }
        return count;
    }

    public int numberOfRareTrades() {
        int count = 0;
        for (MyWandererTrade t : this.trades) {
            if (!t.isRare) continue;
            ++count;
        }
        return count;
    }

    public WandererTradeCollection build() {
        return this;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.removeOtherTrades && this.numberOfGenericTrades() < this.maxCommonTrades) {
            ModLogger.warn("You must have at least " + this.maxCommonTrades + " 'not-rare' trades for the wanderer!");
            isValid = false;
        }
        if (this.removeOtherTrades && this.numberOfRareTrades() < this.maxRareTrades) {
            ModLogger.warn("You must have at least " + this.maxRareTrades + " 'rare' trade for the wanderer!");
            isValid = false;
        }
        for (int i = 0; i < this.trades.length; ++i) {
            if (this.trades[i].validate(this.profession, i)) continue;
            isValid = false;
        }
        return isValid;
    }
}

