/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.maxenchantx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private static final String configDirectory = "config/maxenchantx/";
    private static final Map<String, String> values = new HashMap<String, String>();
    private String config;

    public Config(String name) {
        this.config = name + ".ini";
    }

    public int getInt(String name) {
        return this.getInt(name, 10);
    }

    public int getInt(String name, Integer defaultValue) {
        if (values.containsKey(name)) {
            return Integer.parseInt(values.get(name));
        }
        values.put(name, defaultValue.toString());
        return defaultValue;
    }

    void saveConfig() {
        Config.checkFolder();
        String val = null;
        try {
            FileWriter writer = new FileWriter(new File(configDirectory + this.config));
            for (Map.Entry<String, String> pair : values.entrySet()) {
                val = pair.getKey();
                writer.write(val + "=" + pair.getValue() + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            if (val == null) {
                System.out.println("Failed to save " + this.config);
            } else {
                System.out.println("Failed to save value for " + val);
            }
            System.out.println("Because: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void checkFolder() {
        File folder = new File(configDirectory);
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    public void load() {
        Config.checkFolder();
        File file = new File(configDirectory + this.config);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.replaceAll(" ", "")).startsWith("#") || !line.contains("=")) continue;
                String[] split = line.split("=");
                values.put(split[0], split[1]);
            }
            reader.close();
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

