/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.util.Bounds2i;
import org.joml.Vector2i;

public record ClientCategoryConfig(ResourceLocation id, Component title, ClientIconConfig icon, ClientBackgroundConfig background, ClientColorsConfig colors, boolean exclusiveRoot, int spentPointsLimit, int levelLimit, Map<String, ClientSkillDefinitionConfig> definitions, Map<String, ClientSkillConfig> skills, Collection<ClientSkillConnectionConfig> normalConnections, Collection<ClientSkillConnectionConfig> exclusiveConnections, Map<String, Collection<ClientSkillConnectionConfig>> skillNormalConnections, Map<String, Collection<ClientSkillConnectionConfig>> skillExclusiveConnections, Map<String, Collection<String>> skillNormalNeighbors, Map<String, Collection<String>> skillExclusiveNeighbors, Map<String, Collection<String>> skillNormalNeighborsReversed, Map<String, Collection<String>> skillExclusiveNeighborsReversed) {
    public ClientCategoryConfig(ResourceLocation id, Component title, ClientIconConfig icon, ClientBackgroundConfig background, ClientColorsConfig colors, boolean exclusiveRoot, int spentPointsLimit, int levelLimit, Map<String, ClientSkillDefinitionConfig> definitions, Map<String, ClientSkillConfig> skills, Collection<ClientSkillConnectionConfig> normalConnections, Collection<ClientSkillConnectionConfig> exclusiveConnections) {
        this(id, title, icon, background, colors, exclusiveRoot, spentPointsLimit, levelLimit, definitions, skills, normalConnections, exclusiveConnections, new HashMap<String, Collection<ClientSkillConnectionConfig>>(), new HashMap<String, Collection<ClientSkillConnectionConfig>>(), new HashMap<String, Collection<String>>(), new HashMap<String, Collection<String>>(), new HashMap<String, Collection<String>>(), new HashMap<String, Collection<String>>());
        String b;
        String a;
        for (ClientSkillConnectionConfig connection : normalConnections) {
            a = connection.skillAId();
            b = connection.skillBId();
            this.skillNormalNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            this.skillNormalNeighborsReversed.computeIfAbsent(b, key -> new HashSet()).add(a);
            if (connection.bidirectional()) {
                this.skillNormalNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
                this.skillNormalNeighborsReversed.computeIfAbsent(a, key -> new HashSet()).add(b);
            }
            this.skillNormalConnections.computeIfAbsent(a, key -> new HashSet()).add(connection);
            this.skillNormalConnections.computeIfAbsent(b, key -> new HashSet()).add(connection);
        }
        for (ClientSkillConnectionConfig connection : exclusiveConnections) {
            a = connection.skillAId();
            b = connection.skillBId();
            this.skillExclusiveNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            this.skillExclusiveNeighborsReversed.computeIfAbsent(b, key -> new HashSet()).add(a);
            if (connection.bidirectional()) {
                this.skillExclusiveNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
                this.skillExclusiveNeighborsReversed.computeIfAbsent(a, key -> new HashSet()).add(b);
            }
            this.skillExclusiveConnections.computeIfAbsent(a, key -> new HashSet()).add(connection);
            this.skillExclusiveConnections.computeIfAbsent(b, key -> new HashSet()).add(connection);
        }
    }

    public Bounds2i getBounds() {
        Bounds2i bounds = Bounds2i.zero();
        for (ClientSkillConfig skill : this.skills.values()) {
            bounds.extend(new Vector2i(skill.x(), skill.y()));
        }
        return bounds;
    }

    public Optional<ClientSkillDefinitionConfig> getDefinitionById(String id) {
        return Optional.ofNullable(this.definitions.get(id));
    }
}

