/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.p3pp3rf1y.sophisticatedcore.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemInStorageHighlightRenderer;

public class JeiClientCompat {
    @Nullable
    private static IJeiRuntime runtime = null;

    public static void setRuntime(@Nullable IJeiRuntime runtime) {
        JeiClientCompat.runtime = runtime;
    }

    public static void init() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(JeiClientCompat::handleGuiKeyPress);
        eventBus.addListener(JeiClientCompat::handleGuiMouseKeyPress);
    }

    private static Optional<ItemStack> getStack() {
        return runtime == null ? Optional.empty() : runtime.getIngredientListOverlay().getIngredientUnderMouse().or(() -> runtime.getBookmarkOverlay().getIngredientUnderMouse()).flatMap(ITypedIngredient::getItemStack);
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().m_7379_();
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().m_7379_();
            event.setCanceled(true);
        }
    }

    private static boolean tryHighlightItem(ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        ItemInStorageHighlightRenderer.highlightItem(player, stack);
        return true;
    }
}

