/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.event.HeartRenderEvent;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.Heart;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.render.HeartUtils;

public class HeartRenderer {
    public static final HeartRenderer INSTANCE = new HeartRenderer();
    private final Minecraft client = Minecraft.m_91087_();
    private final RandomSource random = RandomSource.m_216327_();
    private boolean lastHardcore;
    public int lastHealth;
    public int lastMaxHealth;
    public int lastAbsorption;
    private OverlayHeart lastOverlayType;
    private Heart[] hearts;

    public void renderPlayerHearts(GuiGraphics guiGraphics, Player player, int x, int y, int maxHealth, int currentHealth, int displayHealth, int absorption, boolean blinking) {
        OverlayHeart heartType;
        HeartRenderEvent.Pre event;
        long tickCount = this.client.f_91065_.m_93079_();
        this.random.m_188584_(tickCount * 312871L);
        int healthHearts = Mth.m_14165_((double)((double)Math.min(maxHealth, 20) / 2.0));
        int displayHealthHearts = Mth.m_14165_((double)((double)Math.min(displayHealth, 20) / 2.0));
        boolean hardcore = CColorfulHearts.PROXY.forcedHardcoreHearts() || player.m_9236_().m_6106_().m_5466_();
        int regenIndex = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regenIndex = (int)tickCount % Mth.m_14167_((float)(Math.min(maxHealth, 20) + 5));
        }
        if ((event = CColorfulHearts.PROXY.preRenderEvent(guiGraphics, x, y, blinking, hardcore, heartType = (OverlayHeart)Hearts.getOverlayHeartForPlayer(player).orElse(null))).isCancelled()) {
            return;
        }
        x = event.getX();
        y = event.getY();
        blinking = event.isBlinking();
        hardcore = event.isHardcore();
        heartType = event.getOverlayHeart().orElse(null);
        if (this.lastHardcore != hardcore || this.lastHealth != currentHealth || this.lastMaxHealth != maxHealth || this.lastAbsorption != absorption || this.lastOverlayType != heartType || this.hearts == null) {
            this.hearts = HeartUtils.calculateHearts(heartType, currentHealth, maxHealth, absorption);
            this.lastHardcore = hardcore;
            this.lastHealth = currentHealth;
            this.lastMaxHealth = maxHealth;
            this.lastAbsorption = absorption;
            this.lastOverlayType = heartType;
        }
        for (int index = 0; index < this.hearts.length; ++index) {
            Heart heart = this.hearts[index];
            int xPos = x + index % 10 * 8;
            int yPos = y - (index > 9 ? 10 : 0);
            if (currentHealth + absorption <= 4) {
                yPos += this.random.m_188503_(2);
            }
            if (heart == null) continue;
            if (index < healthHearts && index == regenIndex) {
                yPos -= 2;
            }
            boolean blinkingHeart = blinking && index < displayHealthHearts;
            heart.draw(guiGraphics, xPos, yPos, hardcore, blinking, blinkingHeart);
        }
        CColorfulHearts.PROXY.postRenderEvent(guiGraphics, x, y, blinking, hardcore, heartType);
    }
}

