/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.screen.ConfigurationScreen;
import terrails.colorfulhearts.forge.PlatformProxyImpl;
import terrails.colorfulhearts.forge.render.RenderEventHandler;

public class ColorfulHearts {
    public static ForgeConfigSpec CONFIG_SPEC;
    private static final List<ConfigOption<?, ?>> CONFIG_OPTIONS;
    private static final Map<String, String> COMPAT;

    public ColorfulHearts() {
        CColorfulHearts.setupCommon(new PlatformProxyImpl());
        ModLoadingContext context = ModLoadingContext.get();
        String fileName = "colorfulhearts.toml";
        CONFIG_SPEC = this.setupConfig("colorfulhearts.toml");
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_SPEC, "colorfulhearts.toml");
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, lastScreen) -> new ConfigurationScreen((Screen)lastScreen)));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::loadConfig);
        bus.addListener(this::reloadConfig);
        this.setupCompat(bus);
    }

    private void setup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, RenderEventHandler.INSTANCE::renderHearts);
    }

    private void loadConfig(ModConfigEvent.Loading event) {
        CColorfulHearts.LOGGER.info("Loading {} config file", (Object)event.getConfig().getFileName());
        CommentedConfig config = event.getConfig().getConfigData();
        for (ConfigOption<?, ?> option : CONFIG_OPTIONS) {
            option.initialize(() -> config.get(option.getPath()), v -> config.set(option.getPath(), v));
            option.reload();
        }
        ConfigUtils.loadColoredHearts();
        ConfigUtils.loadStatusEffectHearts();
        CColorfulHearts.LOGGER.debug("Loaded {} config file", (Object)event.getConfig().getFileName());
    }

    private void reloadConfig(ModConfigEvent.Reloading event) {
        CColorfulHearts.LOGGER.info("Reloading {} config file", (Object)event.getConfig().getFileName());
        CONFIG_OPTIONS.forEach(ConfigOption::reload);
        ConfigUtils.loadColoredHearts();
        ConfigUtils.loadStatusEffectHearts();
        CColorfulHearts.LOGGER.debug("Reloaded {} config file", (Object)event.getConfig().getFileName());
    }

    private ForgeConfigSpec setupConfig(String fileName) {
        ForgeConfigSpec.Builder specBuilder = new ForgeConfigSpec.Builder();
        for (Object instance : new Object[]{Configuration.HEALTH, Configuration.ABSORPTION}) {
            for (Field field : instance.getClass().getDeclaredFields()) {
                try {
                    Object object = field.get(instance);
                    if (object instanceof ConfigOption) {
                        ConfigOption option = (ConfigOption)object;
                        CONFIG_OPTIONS.add(option);
                        Object c = option.getRawDefault();
                        if (c instanceof List) {
                            List list = (List)c;
                            specBuilder.comment(option.getComment()).defineList(option.getPath(), list, option.getOptionValidator());
                            continue;
                        }
                        specBuilder.comment(option.getComment()).define(option.getPath(), option.getRawDefault(), option.getOptionValidator());
                        continue;
                    }
                    CColorfulHearts.LOGGER.debug("Skipping {} field in {} as it is not a ConfigOption", (Object)field.getName(), (Object)instance.getClass().getName());
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Could not process {} field in {}", (Object)field.getName(), (Object)instance.getClass().getName(), (Object)e);
                }
            }
        }
        return specBuilder.build();
    }

    private void setupCompat(IEventBus bus) {
        String basePackage = "terrails.colorfulhearts.forge.compat";
        for (Map.Entry<String, String> entry : COMPAT.entrySet()) {
            String id = entry.getKey();
            if (ModList.get().isLoaded(id)) {
                String className = "terrails.colorfulhearts.forge.compat." + entry.getValue();
                CColorfulHearts.LOGGER.info("Loading compat for mod {}", (Object)id);
                try {
                    Class<?> compatClass = Class.forName(className);
                    try {
                        compatClass.getDeclaredConstructor(IEventBus.class).newInstance(bus);
                    }
                    catch (NoSuchMethodException ignored) {
                        compatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not exist", (Object)className, (Object)e);
                }
                catch (NoSuchMethodException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid constructor", (Object)className, (Object)e);
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid public constructor", (Object)className, (Object)e);
                }
                catch (InstantiationException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} is an abstract class", (Object)className, (Object)e);
                }
                catch (InvocationTargetException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat {} as an unknown error was thrown", (Object)className, (Object)e);
                }
                continue;
            }
            CColorfulHearts.LOGGER.debug("Skipped loading compat for missing mod {}", (Object)id);
        }
    }

    static {
        CONFIG_OPTIONS = new ArrayList();
        COMPAT = Map.of("appleskin", "AppleSkinCompat", "undergarden", "UndergardenCompat", "farmersdelight", "FarmersDelightCompat", "overflowingbars", "OverflowingBarsCompat", "eidolon", "EidolonRepraisedCompat");
    }
}

