/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class ItemArmorGeoLayer<T extends LivingEntity>
extends GeoRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();
    protected static final HumanoidModel<LivingEntity> INNER_ARMOR_MODEL = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
    protected static final HumanoidModel<LivingEntity> OUTER_ARMOR_MODEL = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    public ItemArmorGeoLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    @Nonnull
    protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || stack != animatable.m_6844_(slot)) continue;
            return slot;
        }
        return EquipmentSlot.CHEST;
    }

    @Nonnull
    protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
        return baseModel.f_102810_;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
        return null;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        this.mainHandStack = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offhandStack = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmetStack = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplateStack = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggingsStack = animatable.m_6844_(EquipmentSlot.LEGS);
        this.bootsStack = animatable.m_6844_(EquipmentSlot.FEET);
    }

    @Override
    public void renderForBone(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(bone, animatable);
        if (armorStack == null) {
            return;
        }
        Item item = armorStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(poseStack, bone, armorStack, skullBlock, bufferSource, packedLight);
        } else {
            EquipmentSlot slot = this.getEquipmentSlotForBone(bone, armorStack, animatable);
            HumanoidModel<?> model = this.getModelForItem(bone, slot, armorStack, animatable);
            ModelPart modelPart = this.getModelPartForBone(bone, slot, armorStack, animatable, model);
            if (!modelPart.f_104212_.isEmpty()) {
                poseStack.m_85836_();
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.prepForRender((Entity)animatable, armorStack, slot, model);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.m_7695_(poseStack, null, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (armorStack.m_41720_() instanceof ArmorItem) {
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    this.renderVanillaArmorPiece(poseStack, animatable, bone, slot, armorStack, modelPart, bufferSource, partialTick, packedLight, packedOverlay);
                }
                poseStack.m_85849_();
            }
        }
        buffer = bufferSource.m_6299_(renderType);
    }

    protected <I extends Item> void renderVanillaArmorPiece(PoseStack poseStack, T animatable, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        ResourceLocation texture = this.getVanillaArmorResource((Entity)animatable, armorStack, slot, "");
        VertexConsumer buffer = this.getArmorBuffer(bufferSource, null, texture, armorStack.m_41790_());
        Item item = armorStack.m_41720_();
        if (item instanceof DyeableArmorItem) {
            DyeableArmorItem dyable = (DyeableArmorItem)item;
            int color = dyable.m_41121_(armorStack);
            modelPart.m_104306_(poseStack, buffer, packedLight, packedOverlay, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
            texture = this.getVanillaArmorResource((Entity)animatable, armorStack, slot, "overlay");
            buffer = this.getArmorBuffer(bufferSource, null, texture, false);
        }
        modelPart.m_104306_(poseStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected VertexConsumer getArmorBuffer(MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable ResourceLocation texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = RenderType.m_110431_((ResourceLocation)texturePath);
        }
        return ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)enchanted);
    }

    @Nonnull
    protected HumanoidModel<?> getModelForItem(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable) {
        HumanoidModel<LivingEntity> defaultModel = slot == EquipmentSlot.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        return IClientItemExtensions.of((ItemStack)stack).getHumanoidArmorModel(animatable, stack, slot, defaultModel);
    }

    public ResourceLocation getVanillaArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        String domain = "minecraft";
        String path = ((ArmorItem)stack.m_41720_()).m_40401_().m_6082_();
        String[] materialNameSplit = path.split(":", 2);
        if (materialNameSplit.length > 1) {
            domain = materialNameSplit[0];
            path = materialNameSplit[1];
        }
        if (!((String)type).isBlank()) {
            type = "_" + (String)type;
        }
        String texture = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, path, slot == EquipmentSlot.LEGS ? 2 : 1, type);
        texture = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)texture, (EquipmentSlot)slot, (String)type);
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::parse);
    }

    protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
        GameProfile skullProfile = null;
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            StringTag tag;
            String skullOwner;
            Tag skullTag = stackTag.m_128423_("SkullOwner");
            if (skullTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)skullTag;
                skullProfile = NbtUtils.m_129228_((CompoundTag)compoundTag);
            } else if (skullTag instanceof StringTag && !(skullOwner = (tag = (StringTag)skullTag).m_7916_()).isBlank()) {
                CompoundTag profileTag = new CompoundTag();
                SkullBlockEntity.m_155738_((GameProfile)new GameProfile(null, skullOwner), name -> stackTag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)profileTag, (GameProfile)name)));
                skullProfile = NbtUtils.m_129228_((CompoundTag)profileTag);
            }
        }
        SkullBlock.Type type = skullBlock.m_48754_();
        SkullModelBase model = (SkullModelBase)SkullBlockRenderer.m_173661_((EntityModelSet)Minecraft.m_91087_().m_167973_()).get(type);
        RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)skullProfile);
        poseStack.m_85836_();
        RenderUtils.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.m_85841_(1.1875f, 1.1875f, 1.1875f);
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.m_173663_(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (SkullModelBase)model, (RenderType)renderType);
        poseStack.m_85849_();
    }

    protected void prepModelPartForRender(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().get(0);
        ModelPart.Cube armorCube = this.getReferenceCubeForModel(bone, sourcePart);
        double armorBoneSizeX = firstCube.size().m_7096_();
        double armorBoneSizeY = firstCube.size().m_7098_();
        double armorBoneSizeZ = firstCube.size().m_7094_();
        double actualArmorSizeX = Math.abs(armorCube.f_104338_ - armorCube.f_104335_);
        double actualArmorSizeY = Math.abs(armorCube.f_104339_ - armorCube.f_104336_);
        double actualArmorSizeZ = Math.abs(armorCube.f_104340_ - armorCube.f_104337_);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.m_104227_(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.f_104203_ = -bone.getRotX();
        sourcePart.f_104204_ = -bone.getRotY();
        sourcePart.f_104205_ = bone.getRotZ();
        poseStack.m_85841_(scaleX, scaleY, scaleZ);
    }

    protected ModelPart.Cube getReferenceCubeForModel(GeoBone bone, ModelPart sourcePart) {
        return (ModelPart.Cube)sourcePart.f_104212_.get(0);
    }
}

