/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import software.bernie.example.client.model.entity.GremlinModel;
import software.bernie.example.entity.DynamicExampleEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.DynamicGeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class GremlinRenderer
extends DynamicGeoEntityRenderer<DynamicExampleEntity> {
    private static final String LEFT_HAND = "bipedHandLeft";
    private static final String RIGHT_HAND = "bipedHandRight";
    private static final String LEFT_BOOT = "armorBipedLeftFoot";
    private static final String RIGHT_BOOT = "armorBipedRightFoot";
    private static final String LEFT_ARMOR_LEG = "armorBipedLeftLeg";
    private static final String RIGHT_ARMOR_LEG = "armorBipedRightLeg";
    private static final String CHESTPLATE = "armorBipedBody";
    private static final String RIGHT_SLEEVE = "armorBipedRightArm";
    private static final String LEFT_SLEEVE = "armorBipedLeftArm";
    private static final String HELMET = "armorBipedHead";
    protected final ResourceLocation CAPE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"textures/entity/dynamic_entity_cape.png");
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public GremlinRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new GremlinModel());
        this.addRenderLayer(new ItemArmorGeoLayer<DynamicExampleEntity>((GeoRenderer)this){

            @Override
            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, DynamicExampleEntity animatable) {
                return switch (bone.getName()) {
                    case GremlinRenderer.LEFT_BOOT, GremlinRenderer.RIGHT_BOOT -> this.bootsStack;
                    case GremlinRenderer.LEFT_ARMOR_LEG, GremlinRenderer.RIGHT_ARMOR_LEG -> this.leggingsStack;
                    case GremlinRenderer.CHESTPLATE, GremlinRenderer.RIGHT_SLEEVE, GremlinRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case GremlinRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Override
            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, DynamicExampleEntity animatable) {
                return switch (bone.getName()) {
                    case GremlinRenderer.LEFT_BOOT, GremlinRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case GremlinRenderer.LEFT_ARMOR_LEG, GremlinRenderer.RIGHT_ARMOR_LEG -> EquipmentSlot.LEGS;
                    case GremlinRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case GremlinRenderer.LEFT_SLEEVE -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case GremlinRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case GremlinRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, animatable);
                };
            }

            @Override
            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, DynamicExampleEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case GremlinRenderer.LEFT_BOOT, GremlinRenderer.LEFT_ARMOR_LEG -> baseModel.f_102814_;
                    case GremlinRenderer.RIGHT_BOOT, GremlinRenderer.RIGHT_ARMOR_LEG -> baseModel.f_102813_;
                    case GremlinRenderer.RIGHT_SLEEVE -> baseModel.f_102811_;
                    case GremlinRenderer.LEFT_SLEEVE -> baseModel.f_102812_;
                    case GremlinRenderer.CHESTPLATE -> baseModel.f_102810_;
                    case GremlinRenderer.HELMET -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, animatable, baseModel);
                };
            }
        });
        this.addRenderLayer(new BlockAndItemGeoLayer<DynamicExampleEntity>((GeoRenderer)this){

            @Override
            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, DynamicExampleEntity animatable) {
                return switch (bone.getName()) {
                    case GremlinRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield GremlinRenderer.this.mainHandItem;
                        }
                        yield GremlinRenderer.this.offhandItem;
                    }
                    case GremlinRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield GremlinRenderer.this.offhandItem;
                        }
                        yield GremlinRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            @Override
            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, DynamicExampleEntity animatable) {
                return switch (bone.getName()) {
                    case GremlinRenderer.LEFT_HAND, GremlinRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            @Override
            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, DynamicExampleEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == GremlinRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == GremlinRenderer.this.offhandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    @Override
    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, DynamicExampleEntity animatable, float partialTick) {
        return "bipedCape".equals(bone.getName()) ? this.CAPE_TEXTURE : null;
    }

    @Override
    public void preRender(PoseStack poseStack, DynamicExampleEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = animatable.m_21205_();
        this.offhandItem = animatable.m_21206_();
    }
}

