/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import io.github.chakyl.societytrading.SocietyTrading;
import io.github.chakyl.societytrading.network.PacketHandler;
import io.github.chakyl.societytrading.network.ServerBoundSearchPacket;
import io.github.chakyl.societytrading.network.ServerBoundTradeButtonClickPacket;
import io.github.chakyl.societytrading.network.ServerBoundTriggerBalanceSyncPacket;
import io.github.chakyl.societytrading.screen.ShopMenu;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import io.github.chakyl.societytrading.util.ScreenUtils;
import io.github.chakyl.societytrading.util.ShopData;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShopScreen
extends AbstractContainerScreen<ShopMenu> {
    private static final ResourceLocation GUI_LOCATION = new ResourceLocation("society_trading", "textures/gui/shop.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 5;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 22;
    private static final int TRADE_BUTTON_WIDTH = 201;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 110;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 290;
    private static final Component TRADES_LABEL = Component.m_237115_((String)"gui.society_trading.search_trades");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[5];
    int scrollOff;
    private boolean isDragging;
    private EditBox searchBox;

    public ShopScreen(ShopMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 304;
        this.f_97727_ = 226;
    }

    private void postButtonClick() {
        PacketHandler.sendToServer(new ServerBoundTradeButtonClickPacket((byte)this.shopItem));
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 18;
        PacketHandler.sendToServer(new ServerBoundTriggerBalanceSyncPacket());
        for (int l = 0; l < 5; ++l) {
            this.tradeOfferButtons[l] = (TradeOfferButton)this.m_142416_((GuiEventListener)new TradeOfferButton(i + 88, k, l, button -> {
                if (button instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 22;
        }
        this.searchBox = new EditBox(this.f_96547_, i + 210, this.f_97736_ + 6, 60, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94190_(false);
        this.searchBox.m_93692_(true);
        this.searchBox.m_93674_(60);
        this.searchBox.m_252865_(i + 210);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 ? true : super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void refreshSearchResults() {
        String s = this.searchBox.m_94155_();
        ((ShopMenu)this.f_97732_).filterOffers(s);
        this.scrollOff = 0;
        PacketHandler.sendToServer(new ServerBoundSearchPacket(s));
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int centralX = 5 - this.f_96547_.m_92852_((FormattedText)TRADES_LABEL) / 2 + 122;
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, 6, 6, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, TRADES_LABEL, centralX, 6, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, centralX, 132, 0x404040, false);
        if (((ShopMenu)this.f_97732_).getPlayerBalance() > 0) {
            MutableComponent priceStr = Component.m_237110_((String)"gui.society_trading.balance", (Object[])new Object[]{"\u00a70" + ShopData.formatPrice(Integer.valueOf(((ShopMenu)this.f_97732_).getPlayerBalance()).toString(), false)});
            pGuiGraphics.m_280614_(this.f_96547_, (Component)priceStr, centralX * 3 - this.f_96547_.m_92852_((FormattedText)priceStr) + 30, 132, 0xFFFFFF, false);
        }
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.searchBox.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280398_(GUI_LOCATION, i, j, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        pGuiGraphics.m_280398_(new ResourceLocation(((ShopMenu)this.f_97732_).getTexture() + ".png"), i + 6, j + 18, 0, 0.0f, 0.0f, 64, 64, 64, 64);
    }

    private void renderScroller(GuiGraphics pGuiGraphics, int pPosX, int pPosY, ShopOffers pShopOffers) {
        int i = pShopOffers.size() + 1 - 5;
        if (i > 1) {
            int j = 110 - (27 + (i - 1) * 110 / i);
            int k = j / i + 110 / i;
            int l = 83;
            int i1 = Math.min(l, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                i1 = l;
            }
            pGuiGraphics.m_280398_(GUI_LOCATION, pPosX + 290, pPosY + 18 + i1, 0, 304.0f, 0.0f, 6, 27, 512, 256);
        } else {
            pGuiGraphics.m_280398_(GUI_LOCATION, pPosX + 290, pPosY + 18, 0, 310.0f, 0.0f, 6, 27, 512, 256);
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        ShopOffers shopOffers = ((ShopMenu)this.f_97732_).getOffers();
        if (!shopOffers.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int k = j + 4 + 1;
            int l = i + 86 + 5;
            this.renderScroller(pGuiGraphics, i, j, shopOffers);
            int i1 = 0;
            for (ShopOffer shopOffer : shopOffers) {
                if (!this.canScroll(shopOffers.size()) || i1 >= this.scrollOff && i1 < 5 + this.scrollOff) {
                    ItemStack itemstack1 = shopOffer.getCostA();
                    ItemStack itemstack2 = shopOffer.getCostB();
                    ItemStack itemstack3 = shopOffer.getResult();
                    pGuiGraphics.m_280168_().m_85836_();
                    pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int j1 = k + 16;
                    boolean noBalance = ((ShopMenu)this.f_97732_).getPlayerBalance() == 0;
                    int numismaticOffset = 0;
                    int priceOffset = 5;
                    if (shopOffer.hasNumismaticsCost() && !noBalance) {
                        numismaticOffset = l + 201 - 21;
                    }
                    if (SocietyTrading.NUMISMATICS_INSTALLED && !itemstack1.m_204117_(NumismaticsTags.AllItemTags.COINS.tag) || noBalance) {
                        this.renderAndDecorateCostA(pGuiGraphics, itemstack1, itemstack1, numismaticOffset > 0 ? numismaticOffset : l + 201 - 21, j1);
                        priceOffset += 18;
                    }
                    if (!itemstack2.m_41619_() && (SocietyTrading.NUMISMATICS_INSTALLED && !itemstack2.m_204117_(NumismaticsTags.AllItemTags.COINS.tag) || noBalance)) {
                        pGuiGraphics.m_280203_(itemstack2, numismaticOffset > 0 ? numismaticOffset : i + 201 + 52, j1);
                        pGuiGraphics.m_280370_(this.f_96547_, itemstack2, numismaticOffset > 0 ? numismaticOffset : i + 201 + 52, j1);
                        priceOffset += 18;
                    }
                    if (SocietyTrading.NUMISMATICS_INSTALLED && shopOffer.hasNumismaticsCost() && !noBalance) {
                        MutableComponent priceStr = Component.m_237110_((String)"gui.society_trading.price", (Object[])new Object[]{ShopData.formatPrice(Integer.valueOf(shopOffer.getNumismaticsCost()).toString())});
                        pGuiGraphics.m_280614_(this.f_96547_, (Component)priceStr, l + 201 - this.f_96547_.m_92852_((FormattedText)priceStr) - priceOffset, j1 + 4, 0xFFFFFF, true);
                    }
                    int lineLength = 102;
                    Component itemName = itemstack3.m_41786_();
                    boolean oneLine = this.f_96547_.m_92923_((FormattedText)itemName, lineLength).size() == 1;
                    pGuiGraphics.m_280203_(itemstack3, l + 1, j1);
                    pGuiGraphics.m_280370_(this.f_96547_, itemstack3, l + 1, j1);
                    ScreenUtils.drawWordWrapShadow(pGuiGraphics, this.f_96547_, (FormattedText)itemName.m_6879_().m_130940_(ChatFormatting.WHITE), l + 16 + 4, j1 + (oneLine ? 4 : 0), lineLength, 0xFFFFFF);
                    pGuiGraphics.m_280168_().m_85849_();
                    k += 22;
                    ++i1;
                    continue;
                }
                ++i1;
            }
        }
        for (TradeOfferButton ShopScreen$tradeofferbutton : this.tradeOfferButtons) {
            if (ShopScreen$tradeofferbutton.m_198029_()) {
                ShopScreen$tradeofferbutton.renderToolTip(pGuiGraphics, pMouseX, pMouseY);
            }
            ShopScreen$tradeofferbutton.f_93624_ = ShopScreen$tradeofferbutton.index < ((ShopMenu)this.f_97732_).getOffers().size();
        }
        RenderSystem.enableDepthTest();
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderAndDecorateCostA(GuiGraphics pGuiGraphics, ItemStack pRealCost, ItemStack pBaseCost, int pX, int pY) {
        pGuiGraphics.m_280203_(pRealCost, pX, pY);
        if (pBaseCost.m_41613_() == pRealCost.m_41613_()) {
            pGuiGraphics.m_280370_(this.f_96547_, pRealCost, pX, pY);
        } else {
            pGuiGraphics.m_280302_(this.f_96547_, pBaseCost, pX, pY, pBaseCost.m_41613_() == 1 ? "1" : null);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            String count = pRealCost.m_41613_() == 1 ? "1" : String.valueOf(pRealCost.m_41613_());
            this.f_96547_.m_272078_(count, (float)(pX + 14) + 19.0f - 2.0f - (float)this.f_96547_.m_92895_(count), (float)pY + 6.0f + 3.0f, 0xFFFFFF, true, pGuiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)pGuiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
            pGuiGraphics.m_280168_().m_85849_();
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            pGuiGraphics.m_280398_(GUI_LOCATION, pX + 7, pY + 12, 0, 0.0f, 176.0f, 9, 2, 512, 256);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    private boolean canScroll(int pNumOffers) {
        return pNumOffers > 5;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int i = ((ShopMenu)this.f_97732_).getOffers().size();
        if (this.canScroll(i)) {
            int j = i - 5;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - pDelta)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = ((ShopMenu)this.f_97732_).getOffers().size();
        if (this.isDragging) {
            int j = this.f_97736_ + 18;
            int k = j + 110;
            int l = i - 5;
            float f = ((float)pMouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((ShopMenu)this.f_97732_).getOffers().size()) && pMouseX > (double)(i + 290) && pMouseX < (double)(i + 290 + 6) && pMouseY > (double)(j + 18) && pMouseY <= (double)(j + 18 + 110 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int pX, int pY, int pIndex, Button.OnPress pOnPress) {
            super(pX, pY, 201, 22, CommonComponents.f_237098_, pOnPress, f_252438_);
            this.index = pIndex;
            this.f_93624_ = false;
        }

        private void priceTooltip(GuiGraphics pGuiGraphics, int price, int pMouseX, int pMouseY) {
            ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>(2);
            tooltipList.add(Component.m_237110_((String)"gui.society_trading.hover_price_one", (Object[])new Object[]{ShopData.formatPrice(String.valueOf(price), false)}));
            tooltipList.add(Component.m_237115_((String)"gui.society_trading.hover_price_two").m_130940_(ChatFormatting.GREEN));
            pGuiGraphics.m_280677_(ShopScreen.this.f_96547_, tooltipList, Items.f_42042_.m_7968_().m_150921_(), pMouseX, pMouseY);
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
            if (this.f_93622_ && ((ShopMenu)ShopScreen.this.f_97732_).getOffers().size() > this.index + ShopScreen.this.scrollOff) {
                boolean renderPrice;
                boolean noBalance = ((ShopMenu)ShopScreen.this.f_97732_).getPlayerBalance() == 0;
                ShopOffer offer = (ShopOffer)((ShopMenu)ShopScreen.this.f_97732_).getOffers().get(this.index + ShopScreen.this.scrollOff);
                ItemStack itemstack1 = offer.getCostA();
                ItemStack itemstack2 = offer.getCostB();
                ItemStack rightMostStack = itemstack1;
                boolean bl = renderPrice = SocietyTrading.NUMISMATICS_INSTALLED && offer.hasNumismaticsCost() && !noBalance;
                if (renderPrice) {
                    if (!itemstack2.m_41619_()) {
                        if (itemstack2.m_204117_(NumismaticsTags.AllItemTags.COINS.tag)) {
                            itemstack2 = ItemStack.f_41583_;
                        } else {
                            rightMostStack = itemstack2;
                            itemstack2 = ItemStack.f_41583_;
                        }
                    }
                    if (rightMostStack.m_204117_(NumismaticsTags.AllItemTags.COINS.tag)) {
                        rightMostStack = ItemStack.f_41583_;
                    }
                }
                if (pMouseX < this.m_252754_() + 20) {
                    ItemStack itemstack = offer.getResult();
                    pGuiGraphics.m_280153_(ShopScreen.this.f_96547_, itemstack, pMouseX, pMouseY);
                } else if (pMouseX < this.m_252754_() + 165 && pMouseX > this.m_252754_() + 148) {
                    if (!itemstack2.m_41619_()) {
                        pGuiGraphics.m_280153_(ShopScreen.this.f_96547_, itemstack2, pMouseX, pMouseY);
                    }
                } else if (pMouseX > this.m_252754_() + 164) {
                    if (!rightMostStack.m_41619_()) {
                        pGuiGraphics.m_280153_(ShopScreen.this.f_96547_, rightMostStack, pMouseX, pMouseY);
                    } else if (renderPrice) {
                        this.priceTooltip(pGuiGraphics, offer.getNumismaticsCost(), pMouseX, pMouseY);
                    }
                }
                if (renderPrice && pMouseX > this.m_252754_() + 116 && pMouseX < this.m_252754_() + 165) {
                    this.priceTooltip(pGuiGraphics, offer.getNumismaticsCost(), pMouseX, pMouseY);
                }
            }
        }
    }
}

