/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.screen;

import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.numismaticsutils.utils.CurioUtils;
import io.github.chakyl.societytrading.SocietyTrading;
import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.data.ShopRegistry;
import io.github.chakyl.societytrading.network.ClientBoundBalancePacket;
import io.github.chakyl.societytrading.network.PacketHandler;
import io.github.chakyl.societytrading.registry.ModElements;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import io.github.chakyl.societytrading.util.ItemHash;
import io.github.chakyl.societytrading.util.ShopData;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShopMenu
extends AbstractContainerMenu {
    protected static final int PAYMENT1_SLOT = 0;
    protected static final int PAYMENT2_SLOT = 1;
    protected static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private static final int SELLSLOT1_X = 136;
    private static final int SELLSLOT2_X = 162;
    private static final int BUYSLOT_X = 220;
    private static final int ROW_Y = 37;
    private final Level level;
    private final int containerId;
    private final Player player;
    private Shop shop;
    private final ResultContainer result = new ResultContainer();
    private final Slot resultSlot;
    private final Container playerInventory;
    private ShopOffer selectedTrade;
    private ShopOffers trades;
    private int quickSlotIteration = 0;
    private int playerBalance = 0;
    private long lastSoundTime;

    public ShopMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, null);
    }

    public ShopMenu(int pContainerId, Inventory pPlayerInventory, String shopID) {
        super((MenuType)ModElements.Menus.SHOP_MENU.get(), pContainerId);
        if (shopID != null) {
            DynamicHolder shop = ShopRegistry.INSTANCE.holder(new ResourceLocation("society_trading:" + shopID));
            this.shop = (Shop)shop.get();
            this.trades = ShopData.getFilteredTrades(this.shop.trades(), pPlayerInventory.f_35978_);
        } else {
            this.shop = null;
            this.trades = null;
        }
        this.player = pPlayerInventory.f_35978_;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.playerInventory = pPlayerInventory;
        this.playerBalance = this.fetchPlayerBalance();
        this.containerId = pContainerId;
        this.resultSlot = this.m_38897_(new ShopResultSlot((Container)this.result, 0, 276, 148));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 88 + j * 18, 144 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 88 + k * 18, 202));
        }
        this.m_38946_();
    }

    public void m_38946_() {
        this.updateResultSlot();
        super.m_38946_();
    }

    public boolean m_6366_(Player player, int button) {
        if (button >= 0 && button < this.trades.size()) {
            this.selectedTrade = (ShopOffer)this.trades.get(button);
            this.quickSlotIteration = 0;
            this.updateResultSlot();
            return true;
        }
        return false;
    }

    private void updateResultSlot() {
        if (!this.level.m_5776_()) {
            int selectedRecipeIndex = this.trades.indexOf(this.selectedTrade);
            if (selectedRecipeIndex >= 0 && selectedRecipeIndex < this.trades.size()) {
                if (this.canTradeFor(this.selectedTrade)) {
                    ItemStack result = this.selectedTrade.getResult();
                    this.resultSlot.m_5852_(result.m_41777_());
                } else {
                    this.resultSlot.m_5852_(ItemStack.f_41583_);
                }
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
            super.m_38946_();
        }
    }

    private boolean canAffordOrNotRelevant(ShopOffer trade) {
        return this.playerBalance <= 0 || !trade.hasNumismaticsCost() || this.playerBalance >= trade.getNumismaticsCost();
    }

    private boolean canTradeFor(ShopOffer selectedTrade) {
        return this.getConsumedMaterialItems(selectedTrade) != null && this.canAffordOrNotRelevant(selectedTrade);
    }

    public void trade(ShopOffer offer, Inventory pPlayerInventory) {
        Map<Item, Integer> items = this.getConsumedMaterialItems(offer);
        if (items != null) {
            this.removeItems(items, pPlayerInventory, offer);
        }
        if (this.playerBalance > 0 && offer.hasNumismaticsCost()) {
            this.getPlayerAccount().deduct(offer.getNumismaticsCost());
            this.updateBalance();
        }
    }

    private boolean hasItemWithNbt(Inventory pPlayerInventory, Item item, CompoundTag nbt) {
        ArrayList foundItems = new ArrayList();
        IntStream.range(0, pPlayerInventory.m_6643_()).forEach(slot -> {
            ItemStack stack = pPlayerInventory.m_8020_(slot);
            if (stack.m_41619_() || stack.m_41768_()) {
                return;
            }
            if (stack.m_41720_() == item && stack.m_41783_() != null && stack.m_41783_().equals((Object)nbt)) {
                foundItems.add(Pair.of((Object)pPlayerInventory, () -> stack.m_41764_(0)));
            }
        });
        return !foundItems.isEmpty();
    }

    private void removeItems(Map<Item, Integer> items, Inventory pPlayerInventory, ShopOffer offer) {
        ArrayList transactions = new ArrayList();
        IntStream.range(0, pPlayerInventory.m_6643_()).forEach(slot -> {
            boolean offerIsExact = true;
            ItemStack stack = pPlayerInventory.m_8020_(slot);
            if (stack.m_41619_() || stack.m_41768_()) {
                return;
            }
            Item item = stack.m_41720_();
            Integer count = (Integer)items.get(item);
            if (count != null) {
                if (offer.getCostA().m_41783_() != null && item == offer.getCostA().m_41720_()) {
                    if (stack.m_41783_() == null) {
                        offerIsExact = false;
                    } else if (!stack.m_41783_().equals((Object)offer.getCostA().m_41783_())) {
                        offerIsExact = false;
                    }
                }
                if (offer.getCostB().m_41783_() != null && item == offer.getCostB().m_41720_()) {
                    if (stack.m_41783_() == null) {
                        offerIsExact = false;
                    } else if (!stack.m_41783_().equals((Object)offer.getCostB().m_41783_())) {
                        offerIsExact = false;
                    }
                }
                if (offerIsExact) {
                    if (stack.m_41613_() < count) {
                        count = count - stack.m_41613_();
                        items.put(item, count);
                        transactions.add(Pair.of((Object)pPlayerInventory, () -> stack.m_41764_(0)));
                    } else {
                        Integer finalCount = count;
                        transactions.add(Pair.of((Object)pPlayerInventory, () -> stack.m_41774_(finalCount.intValue())));
                        items.remove(item);
                    }
                }
            }
        });
        if (items.isEmpty()) {
            transactions.forEach(pair -> {
                ((Runnable)pair.right()).run();
                ((Container)pair.left()).m_6596_();
            });
        }
    }

    public static Map<Item, Integer> countItems(Container pPlayerInventory) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemHash.INSTANCE);
        IntStream.range(0, pPlayerInventory.m_6643_()).forEach(arg_0 -> ShopMenu.lambda$countItems$6(pPlayerInventory, (Map)map, arg_0));
        return map;
    }

    private Map<Item, Integer> addConsumedMaterial(Map<Item, Integer> materials, Map<Item, Integer> counts, ItemStack stack) {
        if (this.playerBalance > 0 && stack.m_204117_(NumismaticsTags.AllItemTags.COINS.tag)) {
            return materials;
        }
        int remaining = stack.m_41613_();
        Item item = stack.m_41720_();
        int count = counts.getOrDefault(item, 0);
        if ((count -= materials.getOrDefault(item, 0).intValue()) > 0) {
            if (stack.m_41783_() != null && !this.hasItemWithNbt(this.player.m_150109_(), item, stack.m_41783_())) {
                return null;
            }
            if (count >= remaining) {
                materials.merge(item, remaining, Integer::sum);
                remaining = 0;
            } else {
                materials.merge(item, count, Integer::sum);
                remaining -= count;
            }
        }
        if (remaining > 0) {
            return null;
        }
        return materials;
    }

    @Nullable
    private Map<Item, Integer> getConsumedMaterialItems(ShopOffer offer) {
        Map<Item, Integer> counts = ShopMenu.countItems(this.playerInventory);
        Map<Item, Integer> materials = new HashMap<Item, Integer>();
        if ((materials = this.addConsumedMaterial(materials, counts, offer.getCostA())) == null) {
            return null;
        }
        return this.addConsumedMaterial(materials, counts, offer.getCostB());
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot != this.resultSlot && super.m_5882_(pStack, pSlot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_7993_().m_41613_() > 0 && this.quickSlotIteration < slot.m_7993_().m_41741_() / slot.m_7993_().m_41613_()) {
            ++this.quickSlotIteration;
            if (slot.m_6657_()) {
                ItemStack slotStack = slot.m_7993_();
                stack = slotStack.m_41777_();
                if (pIndex == this.resultSlot.f_40219_) {
                    Item item = slotStack.m_41720_();
                    item.m_7836_(slotStack, pPlayer.m_9236_(), pPlayer);
                    if (!this.m_38903_(slotStack, 1, this.f_38839_.size(), true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_40234_(slotStack, stack);
                }
                if (slotStack.m_41619_()) {
                    slot.m_269060_(ItemStack.f_41583_);
                }
                slot.m_6654_();
                if (slotStack.m_41613_() == stack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(pPlayer, slotStack);
                this.m_38946_();
            }
        } else {
            this.quickSlotIteration = 0;
        }
        return stack;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
    }

    public void setShop(Shop shop) {
        this.shop = shop;
    }

    public void filterOffers(String searchQuery) {
        ShopOffers availableTrades = ShopData.getFilteredTrades(this.shop.trades(), this.player);
        this.trades = searchQuery.isEmpty() ? availableTrades : ShopData.getSearchedTrades(availableTrades, searchQuery);
    }

    public ShopOffers getOffers() {
        return this.trades;
    }

    public void syncPlayerBalance() {
        if (!this.level.m_5776_()) {
            PacketHandler.sendToPlayer(new ClientBoundBalancePacket(this.getPlayerBalance()), (ServerPlayer)this.player);
        }
    }

    public void updateBalance() {
        int balance = this.fetchPlayerBalance();
        this.setPlayerBalance(balance);
        if (!this.level.m_5776_()) {
            PacketHandler.sendToPlayer(new ClientBoundBalancePacket(balance), (ServerPlayer)this.player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BankAccount getPlayerAccount() {
        if (this.player == null) {
            return null;
        }
        BankAccount account = null;
        if (SocietyTrading.NUMISMATICS_UTILS_INSTALLED) {
            UUID cardUUID = CurioUtils.getCardCurio((Player)this.player);
            if (cardUUID == null) return null;
            account = Numismatics.BANK.getAccount(cardUUID);
        } else {
            Numismatics.BANK.getAccount(this.player.m_20148_());
        }
        if (account != null && account.isAuthorized(this.player.m_20148_())) return account;
        return null;
    }

    public int fetchPlayerBalance() {
        if (!SocietyTrading.NUMISMATICS_INSTALLED || this.level.m_5776_()) {
            return 0;
        }
        if (this.player == null) {
            return 0;
        }
        BankAccount account = this.getPlayerAccount();
        if (account == null) {
            return 0;
        }
        return account.getBalance();
    }

    public int getPlayerBalance() {
        return this.playerBalance;
    }

    public void setPlayerBalance(int balance) {
        this.playerBalance = balance;
    }

    public String getTexture() {
        if (this.shop == null) {
            return null;
        }
        return this.shop.texture();
    }

    private void onTrade(Player player) {
        if (this.selectedTrade != null && this.canTradeFor(this.selectedTrade)) {
            long time;
            this.trade(this.selectedTrade, player.m_150109_());
            this.updateResultSlot();
            this.lastSoundTime = time = this.level.m_46467_();
            if (this.lastSoundTime != this.lastSoundTime) {
                this.level.m_6269_(null, (Entity)player, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.2f, Mth.m_216283_((RandomSource)player.m_9236_().m_213780_(), (float)1.2f, (float)0.0f));
            }
        }
    }

    private static /* synthetic */ void lambda$countItems$6(Container pPlayerInventory, Map map, int slot) {
        ItemStack stack = pPlayerInventory.m_8020_(slot);
        if (stack.m_41619_()) {
            return;
        }
        map.merge(stack.m_41720_(), stack.m_41613_(), Integer::sum);
    }

    private class ShopResultSlot
    extends Slot {
        public ShopResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
            ShopMenu.this.onTrade(player);
            super.m_142406_(player, stack);
        }
    }
}

