/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public record Shop(String shopID, MutableComponent name, String texture, String villagerProfession, EntityType<? extends LivingEntity> entity, TagKey<Block> blockTag, Boolean hiddenFromSelector, ItemStack jeiCatalyst, String stageRequired, String stageOverride, List<String> seasonsRequired, ShopOffers trades) implements CodecProvider<Shop>
{
    public static final Codec<Shop> CODEC = new ShopCodec();
    public static final List<String> POSSIBLE_SEASONS = Arrays.asList("early_spring", "mid_spring", "late_spring", "early_summer", "mid_summer", "late_summer", "early_autumn", "mid_autumn", "late_autumn", "early_winter", "mid_winter", "late_winter");

    public Shop(Shop other) {
        this(other.shopID, other.name, other.texture, other.villagerProfession, other.entity, other.blockTag, other.hiddenFromSelector, other.jeiCatalyst, other.stageRequired, other.stageOverride, other.seasonsRequired, other.trades);
    }

    public int getColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public Shop validate(ResourceLocation key) {
        Preconditions.checkNotNull((Object)this.shopID, (Object)"Invalid shop ID!");
        Preconditions.checkNotNull((Object)this.name, (Object)"Invalid shop name!");
        Preconditions.checkNotNull((Object)this.texture, (Object)"Missing texture!");
        if (this.seasonsRequired != null) {
            this.seasonsRequired.forEach(season -> {
                if (!POSSIBLE_SEASONS.contains(season.replace("\"", ""))) {
                    throw new NullPointerException("Season " + season + " that doesn't exist! Possible values: " + String.valueOf(POSSIBLE_SEASONS));
                }
            });
        }
        return this;
    }

    public Codec<? extends Shop> getCodec() {
        return CODEC;
    }

    public static class ShopCodec
    implements Codec<Shop> {
        public <T> DataResult<T> encode(Shop input, DynamicOps<T> ops, T prefix) {
            JsonObject obj = new JsonObject();
            ResourceLocation key = new ResourceLocation("society_trading", input.shopID);
            obj.addProperty("shop_id", input.shopID);
            obj.addProperty("name", ((TranslatableContents)input.name.m_214077_()).m_237508_());
            obj.addProperty("texture", input.texture);
            obj.addProperty("villager_profession", input.villagerProfession);
            obj.addProperty("entity", EntityType.m_20613_(input.entity).toString());
            if (input.blockTag != null) {
                obj.addProperty("block_tag", input.blockTag.f_203868_().toString());
            }
            obj.addProperty("hidden_from_selector", input.hiddenFromSelector);
            obj.add("jei_catalyst", ItemAdapter.ITEM_READER.toJsonTree((Object)input.jeiCatalyst));
            obj.addProperty("stage_required", input.stageRequired);
            obj.addProperty("stage_override", input.stageOverride);
            JsonArray seasonsRequired = new JsonArray();
            obj.add("seasons_required", (JsonElement)seasonsRequired);
            for (String season : input.seasonsRequired) {
                seasonsRequired.add(season.replace("\"", ""));
            }
            JsonArray trades = new JsonArray();
            obj.add("trades", (JsonElement)trades);
            for (ShopOffer trade : input.trades) {
                JsonObject tradeObj = new JsonObject();
                JsonElement request = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getCostA());
                JsonObject requestJson = request.getAsJsonObject();
                ResourceLocation requestItemName = new ResourceLocation(requestJson.get("item").getAsString());
                JsonElement secondRequest = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getCostB());
                JsonObject secondRequestJson = secondRequest.getAsJsonObject();
                ResourceLocation secondRequestItemName = new ResourceLocation(secondRequestJson.get("item").getAsString());
                JsonElement offer = ItemAdapter.ITEM_READER.toJsonTree((Object)trade.getResult());
                JsonObject offerJson = offer.getAsJsonObject();
                ResourceLocation offerItemName = new ResourceLocation(offerJson.get("item").getAsString());
                if (!"minecraft".equals(offerItemName.m_135827_()) && !key.m_135827_().equals(offerItemName.m_135827_())) {
                    offerJson.addProperty("optional", Boolean.valueOf(true));
                }
                if (!"minecraft".equals(requestItemName.m_135827_()) && !key.m_135827_().equals(requestItemName.m_135827_())) {
                    requestJson.addProperty("optional", Boolean.valueOf(true));
                }
                if (!"minecraft".equals(secondRequestItemName.m_135827_()) && !key.m_135827_().equals(secondRequestItemName.m_135827_())) {
                    secondRequestJson.addProperty("optional", Boolean.valueOf(true));
                }
                JsonArray tradeSeasonsRequired = new JsonArray();
                for (String season : trade.getSeasonsRequired()) {
                    tradeSeasonsRequired.add(season.replace("\"", ""));
                }
                tradeObj.add("request", (JsonElement)requestJson);
                tradeObj.add("second_request", (JsonElement)secondRequestJson);
                tradeObj.add("offer", (JsonElement)offerJson);
                if (!Objects.equals(trade.getUnlockDescription(), Component.m_237119_())) {
                    tradeObj.addProperty("unlock_description", ((TranslatableContents)trade.getUnlockDescription().m_214077_()).m_237508_());
                }
                tradeObj.addProperty("stage_required", trade.getStageRequired());
                tradeObj.addProperty("stage_override", trade.getStageOverride());
                tradeObj.add("seasons_required", (JsonElement)tradeSeasonsRequired);
                tradeObj.addProperty("numismatics_cost", (Number)trade.getNumismaticsCost());
                trades.add((JsonElement)tradeObj);
            }
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)obj));
        }

        public <T> DataResult<Pair<Shop, T>> decode(DynamicOps<T> ops, T input) {
            String entityStr;
            JsonObject obj = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
            String shopId = GsonHelper.m_13906_((JsonObject)obj, (String)"shop_id");
            MutableComponent name = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"name"));
            String texture = GsonHelper.m_13906_((JsonObject)obj, (String)"texture");
            String villagerProfession = "";
            if (obj.has("villager_profession")) {
                villagerProfession = GsonHelper.m_13906_((JsonObject)obj, (String)"villager_profession");
            }
            EntityType entity = null;
            if (obj.has("entity") && (entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityStr = GsonHelper.m_13906_((JsonObject)obj, (String)"entity")))) == EntityType.f_20510_ && !"minecraft:pig".equals(entityStr)) {
                throw new JsonParseException("Shop has entity type " + entityStr);
            }
            TagKey blockTag = null;
            if (obj.has("block_tag")) {
                blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(obj.get("block_tag").getAsString()));
            }
            boolean hiddenFromSelector = false;
            if (obj.has("hidden_from_selector")) {
                hiddenFromSelector = GsonHelper.m_13912_((JsonObject)obj, (String)"hidden_from_selector");
            }
            ItemStack jeiCatalyst = Items.f_42601_.m_7968_();
            if (obj.has("jei_catalyst")) {
                jeiCatalyst = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)obj.getAsJsonObject("jei_catalyst"), ItemStack.class);
            }
            String stageRequired = "";
            if (obj.has("stage_required")) {
                stageRequired = GsonHelper.m_13906_((JsonObject)obj, (String)"stage_required");
            }
            String stageOverride = "";
            if (obj.has("stage_override")) {
                stageOverride = GsonHelper.m_13906_((JsonObject)obj, (String)"stage_override");
            }
            ArrayList<String> seasonsRequired = new ArrayList<String>();
            if (obj.has("seasons_required")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"seasons_required")) {
                    seasonsRequired.add(String.valueOf(json).replace("\"", ""));
                }
            }
            ShopOffers trades = new ShopOffers();
            if (obj.has("trades")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"trades")) {
                    if (!json.getAsJsonObject().has("offer") || !json.getAsJsonObject().has("request")) continue;
                    ItemStack request = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("request"), ItemStack.class);
                    ItemStack offer = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("offer"), ItemStack.class);
                    String tradeStage = "";
                    String tradeStageOverride = "";
                    int numismaticsCost = 0;
                    ArrayList<String> tradeSeasonsRequired = new ArrayList<String>();
                    if (json.getAsJsonObject().has("seasons_required")) {
                        for (JsonElement arrayJson : GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"seasons_required")) {
                            tradeSeasonsRequired.add(String.valueOf(arrayJson).replace("\"", ""));
                        }
                    }
                    MutableComponent tradeUnlockDescription = Component.m_237119_();
                    if (json.getAsJsonObject().has("unlock_description")) {
                        tradeUnlockDescription = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"unlock_description"));
                    }
                    if (json.getAsJsonObject().has("stage_required")) {
                        tradeStage = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"stage_required");
                    }
                    if (json.getAsJsonObject().has("stage_override")) {
                        tradeStageOverride = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"stage_override");
                    }
                    if (json.getAsJsonObject().has("numismatics_cost")) {
                        numismaticsCost = GsonHelper.m_13927_((JsonObject)json.getAsJsonObject(), (String)"numismatics_cost");
                    }
                    if (json.getAsJsonObject().has("second_request")) {
                        ItemStack secondRequest = (ItemStack)ItemAdapter.ITEM_READER.fromJson((JsonElement)json.getAsJsonObject().getAsJsonObject("second_request"), ItemStack.class);
                        trades.add(new ShopOffer(request, secondRequest, offer, tradeUnlockDescription, tradeStage, tradeStageOverride, tradeSeasonsRequired, numismaticsCost));
                        continue;
                    }
                    trades.add(new ShopOffer(request, offer, tradeUnlockDescription, tradeStage, tradeStageOverride, tradeSeasonsRequired, numismaticsCost));
                }
            }
            return DataResult.success((Object)Pair.of((Object)new Shop(shopId, name, texture, villagerProfession, (EntityType<? extends LivingEntity>)entity, (TagKey<Block>)blockTag, hiddenFromSelector, jeiCatalyst, stageRequired, stageOverride, seasonsRequired, trades), input));
        }
    }
}

