/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public interface RegistryManager {
    public static RegistryManager from(String modId) {
        return ModContext.get(modId).getRegistryManagerV3();
    }

    default public <T> ResourceKey<T> makeResourceKey(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return ResourceKey.m_135785_(registryKey, (ResourceLocation)this.makeKey(path));
    }

    public ResourceLocation makeKey(String var1);

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        Objects.checkIndex(0, forbiddenModLoaders.length);
        return this.whenOn((ModLoader[])EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(forbiddenModLoaders), ModLoader.class)).toArray(ModLoader[]::new));
    }

    public <T> Holder.Reference<T> getHolder(ResourceKey<? extends Registry<? super T>> var1, String var2);

    public <T> Holder.Reference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public Holder.Reference<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Registries.f_256747_, path, entry);
    }

    default public Holder.Reference<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Registries.f_256913_, path, entry);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder.Reference<Block> blockReference) {
        return this.registerBlockItem(blockReference, new Item.Properties());
    }

    default public Holder.Reference<Item> registerBlockItem(Holder.Reference<Block> blockReference, Item.Properties itemProperties) {
        return this.registerItem(blockReference.m_205785_().m_135782_().m_135815_(), () -> new BlockItem((Block)blockReference.m_203334_(), itemProperties));
    }

    default public Holder.Reference<Item> registerSpawnEggItem(Holder.Reference<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeReference, backgroundColor, highlightColor, new Item.Properties());
    }

    public Holder.Reference<Item> registerSpawnEggItem(Holder.Reference<? extends EntityType<? extends Mob>> var1, int var2, int var3, Item.Properties var4);

    default public Holder.Reference<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Registries.f_256808_, path, entry);
    }

    default public Holder.Reference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(Registries.f_256929_, path, entry);
    }

    default public Holder.Reference<SoundEvent> registerSoundEvent(String path) {
        return this.register(Registries.f_256840_, path, () -> SoundEvent.m_262824_((ResourceLocation)this.makeKey(path)));
    }

    default public Holder.Reference<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Registries.f_256973_, path, entry);
    }

    default public Holder.Reference<Enchantment> registerEnchantment(String path, Supplier<Enchantment> entry) {
        return this.register(Registries.f_256762_, path, entry);
    }

    default public <T extends Entity> Holder.Reference<EntityType<T>> registerEntityType(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.register(Registries.f_256939_, path, () -> ((EntityType.Builder)entry.get()).m_20712_(path));
    }

    default public <T extends BlockEntity> Holder.Reference<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType.Builder<T>> entry) {
        return this.register(Registries.f_256922_, path, () -> ((BlockEntityType.Builder)entry.get()).m_58966_(null));
    }

    default public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerMenuType(String path, Supplier<MenuType.MenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> new MenuType((MenuType.MenuSupplier)entry.get(), FeatureFlags.f_244332_));
    }

    public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    default public Holder.Reference<PoiType> registerPoiType(String path, Supplier<Block> block) {
        return this.registerPoiType(path, () -> ImmutableSet.copyOf((Collection)((Block)block.get()).m_49965_().m_61056_()), 0, 1);
    }

    public Holder.Reference<PoiType> registerPoiType(String var1, Supplier<Set<BlockState>> var2, int var3, int var4);

    default public <T extends Recipe<?>> Holder.Reference<RecipeType<T>> registerRecipeType(final String path) {
        return this.register(Registries.f_256954_, path, () -> new RecipeType<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public Holder.Reference<GameEvent> registerGameEvent(String path, int notificationRadius) {
        return this.register(Registries.f_256827_, path, () -> new GameEvent(path, notificationRadius));
    }

    default public Holder.Reference<SimpleParticleType> registerParticleType(String path) {
        return this.register(Registries.f_256890_, path, () -> new SimpleParticleType(false));
    }

    default public ResourceKey<DamageType> registerDamageType(String path) {
        return this.makeResourceKey(Registries.f_268580_, path);
    }
}

