/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.event.v1.core;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class EventResultHolder<T> {
    private static final EventResultHolder<?> PASS = new EventResultHolder();
    @NotNull
    private final EventResult result;
    @NotNull
    private final T value;

    private EventResultHolder() {
        this.result = EventResult.PASS;
        this.value = null;
    }

    private EventResultHolder(@NotNull EventResult result, @NotNull T value) {
        Objects.requireNonNull(result, "result is null");
        Objects.requireNonNull(value, "value is null");
        this.result = result;
        this.value = value;
    }

    public static <T> EventResultHolder<T> pass() {
        return PASS;
    }

    public static <T> EventResultHolder<T> interrupt(@NotNull T value) {
        return new EventResultHolder<T>(EventResult.INTERRUPT, value);
    }

    public static <T> EventResultHolder<T> allow(@NotNull T value) {
        return new EventResultHolder<T>(EventResult.ALLOW, value);
    }

    public static <T> EventResultHolder<T> deny(@NotNull T value) {
        return new EventResultHolder<T>(EventResult.DENY, value);
    }

    public boolean isInterrupt() {
        return this.result.isInterrupt();
    }

    public boolean isPass() {
        return this.result.isPass();
    }

    public EventResultHolder<T> ifInterrupt(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isInterrupt() && this.result.getAsBoolean()) {
            action.accept(this.value);
        }
        return this;
    }

    public EventResultHolder<T> ifAllow(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isInterrupt() && this.result.getAsBoolean()) {
            action.accept(this.value);
        }
        return this;
    }

    public EventResultHolder<T> ifDeny(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isInterrupt() && !this.result.getAsBoolean()) {
            action.accept(this.value);
        }
        return this;
    }

    public EventResultHolder<T> filter(Predicate<? super T> filter) {
        Objects.requireNonNull(filter, "filter is null");
        if (!this.isInterrupt()) {
            return this;
        }
        return filter.test(this.value) ? this : EventResultHolder.pass();
    }

    public <U> EventResultHolder<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.isInterrupt()) {
            return EventResultHolder.pass();
        }
        return new EventResultHolder<U>(this.result, mapper.apply(this.value));
    }

    public <U> EventResultHolder<U> flatMap(Function<? super T, ? extends EventResultHolder<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.isInterrupt()) {
            return EventResultHolder.pass();
        }
        EventResultHolder<? extends U> holder = mapper.apply(this.value);
        Objects.requireNonNull(holder, "holder is null");
        return holder;
    }

    public Optional<T> getInterrupt() {
        if (!this.isInterrupt() || !this.result.getAsBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }

    public Optional<T> getAllow() {
        if (!this.isInterrupt() || !this.result.getAsBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }

    public Optional<T> getDeny() {
        if (!this.isInterrupt() || this.result.getAsBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }
}

