/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[\\-_\\s]?(.*)");
    public final String version;
    public final int major;
    public final int minor;
    public final int revision;
    public final String extra;

    public Version(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.revision = Integer.parseInt(matcher.group(3));
            this.extra = matcher.groupCount() > 3 ? matcher.group(4) : null;
        } else {
            throw new IllegalArgumentException("Can't parse version from '" + version + "'");
        }
    }

    public boolean atLeast(Version required) {
        return this.compareTo(required) >= 0;
    }

    public boolean inRange(Version min, Version max) {
        return this.compareTo(min) >= 0 && this.compareTo(max) < 0;
    }

    @Override
    public int compareTo(Version o) {
        int delta = this.major - o.major;
        if (delta == 0 && (delta = this.minor - o.minor) == 0) {
            delta = this.revision - o.revision;
        }
        return delta;
    }

    public String toString() {
        return this.version;
    }
}

