/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import java.io.File;
import java.util.List;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.MediaSlaveType;
import org.watermedia.videolan4j.player.base.BaseApi;
import org.watermedia.videolan4j.player.base.Descriptions;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.base.TrackDescription;

public final class SubpictureApi
extends BaseApi {
    SubpictureApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int trackCount() {
        return LibVlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    public int track() {
        return LibVlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    public int setTrack(int spu) {
        LibVlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
        return this.track();
    }

    public long delay() {
        return LibVlc.libvlc_video_get_spu_delay(this.mediaPlayerInstance);
    }

    public void setDelay(long delay) {
        LibVlc.libvlc_video_set_spu_delay(this.mediaPlayerInstance, delay);
    }

    public boolean setSubTitleFile(String subTitleFileName) {
        return this.setSubTitleUri(subTitleFileName);
    }

    public boolean setSubTitleFile(File subTitleFile) {
        return this.setSubTitleUri(subTitleFile.getAbsolutePath());
    }

    public boolean setSubTitleUri(String uri) {
        return this.mediaPlayer.media().addSlave(MediaSlaveType.SUBTITLE, uri, true);
    }

    public List<TrackDescription> trackDescriptions() {
        return Descriptions.spuTrackDescriptions(this.mediaPlayerInstance);
    }
}

