/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.model.search;

import org.watermedia.shaded.fastjson.JSONObject;
import org.watermedia.shaded.kiulian.downloader.model.Utils;
import org.watermedia.shaded.kiulian.downloader.model.search.AbstractSearchResultList;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultChannelDetails
extends AbstractSearchResultList {
    private final String channelId;
    private final String videoCountText;
    private final String subscriberCountText;
    private final String description;

    public SearchResultChannelDetails(JSONObject json) {
        super(json);
        this.channelId = json.getString("channelId");
        this.videoCountText = Utils.parseRuns(json.getJSONObject("videoCountText"));
        this.subscriberCountText = json.containsKey("subscriberCountText") ? json.getJSONObject("subscriberCountText").getString("simpleText") : null;
        this.description = Utils.parseRuns(json.getJSONObject("descriptionSnippet"));
        this.thumbnails = Utils.parseThumbnails(json.getJSONObject("thumbnail"));
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.CHANNEL;
    }

    @Override
    public SearchResultChannelDetails asChannel() {
        return this;
    }

    public String channelId() {
        return this.channelId;
    }

    public String videoCountText() {
        return this.videoCountText;
    }

    public String subscriberCountText() {
        return this.subscriberCountText;
    }

    public String description() {
        return this.description;
    }
}

